/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import java.util.ArrayList;
import java.util.Arrays;

public class PhetTestApplication {
    private String[] args;
    private FrameSetup frameSetup;
    private ApplicationConstructor appConstructor;
    private ArrayList modules = new ArrayList();

    public PhetTestApplication(String[] stringArray) {
        this(stringArray, null);
    }

    public PhetTestApplication(String[] stringArray, FrameSetup frameSetup) {
        this.args = this.processArgs(stringArray);
        this.frameSetup = frameSetup;
    }

    private String[] processArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.add("-statistics-off");
        arrayList.add("-updates-off");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addModule(Module module) {
        this.modules.add(module);
    }

    public void startApplication() {
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(this.args, "phetcommon");
        if (this.frameSetup != null) {
            phetApplicationConfig.setFrameSetup(this.frameSetup);
        }
        if (this.appConstructor == null) {
            this.appConstructor = new ApplicationConstructor(){

                public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                    PhetApplication phetApplication = new PhetApplication(phetApplicationConfig){};
                    phetApplication.setModules(PhetTestApplication.this.modules.toArray(new Module[PhetTestApplication.this.modules.size()]));
                    return phetApplication;
                }
            };
        }
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, this.appConstructor);
    }
}

