/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;

public class MultiStateButton
extends JButton {
    private Mode mode;
    private ArrayList modes = new ArrayList();

    public MultiStateButton() {
        this(new Mode[0]);
    }

    public MultiStateButton(Mode[] modeArray) {
        for (int i = 0; i < modeArray.length; ++i) {
            this.addMode(modeArray[i].getKey(), modeArray[i].getLabel(), modeArray[i].getIcon());
        }
        this.init();
    }

    private void init() {
        if (this.getNumModes() > 0) {
            this.setMode(0);
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mode mode = MultiStateButton.this.mode;
                int n = MultiStateButton.this.modes.indexOf(MultiStateButton.this.mode);
                MultiStateButton.this.setMode((n + 1) % MultiStateButton.this.modes.size());
                mode.dispatchEvent(actionEvent);
            }
        });
    }

    private void setMode(int n) {
        this.setMode(this.getMode(n));
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.updateButton();
    }

    public Mode getMode(int n) {
        return (Mode)this.modes.get(n);
    }

    public void addMode(Object object, String string, Icon icon) {
        this.addMode(new Mode(object, string, icon));
    }

    public void addMode(Mode mode) {
        if (this.getMode(mode.getKey()) != null) {
            throw new IllegalArgumentException("Duplicate mode not allowed, key=" + mode.getKey());
        }
        this.modes.add(mode);
        this.updateDimension();
        if (this.mode == null) {
            this.setMode(mode);
        }
        this.updateButton();
    }

    public int getNumModes() {
        return this.modes.size();
    }

    private void updateDimension() {
        int n;
        Dimension[] dimensionArray = new Dimension[this.modes.size()];
        for (n = 0; n < this.modes.size(); ++n) {
            this.setIconAndText((Mode)this.modes.get(n));
            dimensionArray[n] = this.getUI().getPreferredSize(this);
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < dimensionArray.length; ++i) {
            Dimension dimension = dimensionArray[i];
            n = Math.max(dimension.width, n);
            n2 = Math.max(dimension.height, n2);
        }
        this.setPreferredSize(new Dimension(n, n2));
    }

    private Mode getMode(Object object) {
        for (int i = 0; i < this.modes.size(); ++i) {
            Mode mode = (Mode)this.modes.get(i);
            if (!mode.getKey().equals(object)) continue;
            return mode;
        }
        return null;
    }

    private void setIconAndText(Mode mode) {
        this.setText(mode.getLabel());
        this.setIcon(mode.getIcon());
    }

    private void updateButton() {
        this.setIconAndText(this.mode);
    }

    public void addActionListener(Object object, ActionListener actionListener) {
        this.getMode(object).addActionListener(actionListener);
    }

    protected static class Mode {
        private Object key;
        private String label;
        private Icon icon;
        private ArrayList actionListeners = new ArrayList();

        public Mode(Object object, String string, Icon icon) {
            this.key = object;
            this.label = string;
            this.icon = icon;
        }

        public Object getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void dispatchEvent(ActionEvent actionEvent) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener actionListener = (ActionListener)this.actionListeners.get(i);
                actionListener.actionPerformed(actionEvent);
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListeners.add(actionListener);
        }
    }
}

