/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.LightSimulationPanel;
import edu.colorado.phet.waveinterference.ResizeHandler;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.waveinterference.view.LaserControlPanel;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class LaserControlPanelPNode
extends PNode {
    private WaveModelGraphic waveModelGraphic;
    private Oscillator secondaryOscillator;
    private LightSimulationPanel lightSimulationPanel;
    private Oscillator primaryOscillator;
    private PSwing laserControlPSwing;

    public LaserControlPanelPNode(LightSimulationPanel lightSimulationPanel, WaveModelGraphic waveModelGraphic, Oscillator oscillator, Oscillator oscillator2) {
        this.lightSimulationPanel = lightSimulationPanel;
        this.primaryOscillator = oscillator;
        this.waveModelGraphic = waveModelGraphic;
        this.secondaryOscillator = oscillator2;
        LaserControlPanel laserControlPanel = new LaserControlPanel(waveModelGraphic, oscillator);
        oscillator.addListener(new Oscillator.Adapter(){

            public void frequencyChanged() {
                LaserControlPanelPNode.this.updateFrequency();
            }
        });
        this.laserControlPSwing = new PSwing(new ShinyPanel(laserControlPanel));
        ResizeHandler.getInstance().setResizable(lightSimulationPanel, this.laserControlPSwing, 0.9);
        this.addChild(this.laserControlPSwing);
        waveModelGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LaserControlPanelPNode.this.updateLocation();
            }
        });
        waveModelGraphic.getLatticeScreenCoordinates().addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                LaserControlPanelPNode.this.updateLocation();
            }
        });
        this.updateLocation();
        this.updateFrequency();
    }

    private void updateFrequency() {
        this.secondaryOscillator.setFrequency(this.primaryOscillator.getFrequency());
    }

    private void updateLocation() {
        this.setOffset(0.0, this.waveModelGraphic.getLatticeScreenCoordinates().getScreenRect().getMaxY() - this.getFullBounds().getHeight());
    }
}

