/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.LightSimulationPanel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.ScreenNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class PlayAreaReducedScreenControlPanel
extends PhetPNode {
    private LightSimulationPanel lightSimulationPanel;
    private ScreenNode screenNode;
    private PhetPNode showButton;
    private PhetPNode closeButtonNode;

    public PlayAreaReducedScreenControlPanel(LightSimulationPanel lightSimulationPanel, final ScreenNode screenNode) {
        this.lightSimulationPanel = lightSimulationPanel;
        this.screenNode = screenNode;
        JButton jButton = new JButton(WIStrings.getString("light.show-screen"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenNode.setScreenEnabled(true);
            }
        });
        this.showButton = new PhetPNode(new PSwing(jButton));
        this.addChild(this.showButton);
        lightSimulationPanel.getLatticeScreenCoordinates().addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                PlayAreaReducedScreenControlPanel.this.update();
            }
        });
        screenNode.addListener(new ScreenNode.Listener(){

            public void enabledStateChanged() {
                PlayAreaReducedScreenControlPanel.this.updateExpanded();
            }
        });
        JButton jButton2 = null;
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("wave-interference/images/x-20.png");
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, (int)((double)bufferedImage.getHeight() * 0.75));
            jButton2 = new JButton(new ImageIcon(bufferedImage));
            jButton2.setMargin(new Insets(2, 2, 2, 2));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    screenNode.setScreenEnabled(false);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.closeButtonNode = new PhetPNode(new PSwing(jButton2));
        this.addChild(this.closeButtonNode);
        this.update();
        this.updateExpanded();
    }

    private void update() {
        this.showButton.setOffset(this.lightSimulationPanel.getLatticeScreenCoordinates().getScreenRect().getMaxX(), this.lightSimulationPanel.getLatticeScreenCoordinates().getScreenRect().getCenterY());
        this.closeButtonNode.setOffset(this.screenNode.getBrightnessScreenGraphic().getFullBounds().getCenterX() - this.closeButtonNode.getFullBounds().getWidth() / 2.0, 0.0);
    }

    private void updateExpanded() {
        this.showButton.setVisible(!this.screenNode.isScreenEnabled());
        this.closeButtonNode.setVisible(this.screenNode.isScreenEnabled());
    }

    public void reset() {
        this.screenNode.reset();
        this.updateExpanded();
    }
}

