/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.SoundControlPanel;
import edu.colorado.phet.waveinterference.SoundModuleAudio;
import edu.colorado.phet.waveinterference.SoundSimulationPanel;
import edu.colorado.phet.waveinterference.SoundWaveGraphic;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveInterferenceModule;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;

public class SoundModule
extends WaveInterferenceModule {
    private SoundSimulationPanel soundSimulationPanel;
    private WaveInterferenceModel waveInterferenceModel = new SoundModel();
    private SoundControlPanel soundControlPanel;
    private SoundModuleAudio soundModuleAudio = new SoundModuleAudio(this.waveInterferenceModel);

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.soundSimulationPanel.getRotationWaveGraphic();
    }

    public void setAsymmetricFeaturesEnabled(boolean bl) {
        this.soundControlPanel.setAsymmetricFeaturesEnabled(bl);
    }

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.soundSimulationPanel.getScreenUnits();
    }

    public CompositePotential getWallPotentials() {
        return this.waveInterferenceModel.getWallPotentials();
    }

    public void activate() {
        super.activate();
        this.soundModuleAudio.setActive(true);
    }

    public void deactivate() {
        super.deactivate();
        this.soundModuleAudio.setActive(false);
    }

    public SoundModule(boolean bl) {
        super(WIStrings.getString("module.sound"));
        this.soundSimulationPanel = new SoundSimulationPanel(this);
        this.soundControlPanel = new SoundControlPanel(this, bl);
        this.addModelElement(this.waveInterferenceModel);
        this.addModelElement(this.soundSimulationPanel);
        this.setSimulationPanel(this.soundSimulationPanel);
        this.setControlPanel(this.soundControlPanel);
        this.waveInterferenceModel.setInitialConditions();
    }

    public WaveModel getWaveModel() {
        return this.waveInterferenceModel.getWaveModel();
    }

    public SlitPotential getSlitPotential() {
        return this.waveInterferenceModel.getSlitPotential();
    }

    public Oscillator getSecondaryOscillator() {
        return this.waveInterferenceModel.getSecondaryOscillator();
    }

    public Oscillator getPrimaryOscillator() {
        return this.waveInterferenceModel.getPrimaryOscillator();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.soundSimulationPanel.getIntensityReaderSet();
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.soundSimulationPanel.getMeasurementToolSet();
    }

    public SoundSimulationPanel getSoundSimulationPanel() {
        return this.soundSimulationPanel;
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.soundSimulationPanel.getLatticeScreenCoordinates();
    }

    public SoundWaveGraphic getSoundWaveGraphic() {
        return this.soundSimulationPanel.getSoundWaveGraphic();
    }

    public MultiOscillator getMultiOscillator() {
        return this.soundSimulationPanel.getMultiOscillator();
    }

    public SoundModuleAudio getAudioSubsystem() {
        return this.soundModuleAudio;
    }

    public WaveInterferenceModel getWaveInterferenceModel() {
        return this.waveInterferenceModel;
    }

    public void resetAll() {
        super.resetAll();
        this.getWaveInterferenceModel().reset();
        this.soundSimulationPanel.reset();
        this.soundModuleAudio.reset();
    }

    public static class SoundModel
    extends WaveInterferenceModel {
        public SoundModel() {
            this.setDistanceUnits(WIStrings.getString("units.cm"));
            this.setPhysicalSize(100.0, 100.0);
            this.setTimeScale(0.7042253521126761);
            this.setTimeUnits(WIStrings.getString("units.ms"));
        }
    }
}

