/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.waveinterference.OscillatingSpeakerGraphic;
import edu.colorado.phet.waveinterference.RotationWaveGraphic3D;
import edu.colorado.phet.waveinterference.SoundModule;
import edu.colorado.phet.waveinterference.SoundWaveGraphic;
import edu.colorado.phet.waveinterference.SoundWaveGraphicRadioControl;
import edu.colorado.phet.waveinterference.SpeakerConnectorLeftSide;
import edu.colorado.phet.waveinterference.SpeakerControlPanelPNode;
import edu.colorado.phet.waveinterference.ThisSideUpWrapper;
import edu.colorado.phet.waveinterference.UpdateWaveChartCrossSection;
import edu.colorado.phet.waveinterference.WaveInterferenceCanvas;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveSizeButtonPSwing;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.waveinterference.phetcommon.VerticalConnector;
import edu.colorado.phet.waveinterference.tests.ExpandableWaveChart;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.CompositeWallPotentialGraphic;
import edu.colorado.phet.waveinterference.view.CrossSectionGraphic;
import edu.colorado.phet.waveinterference.view.ImageOscillatorPNode;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.PressureWaveGraphic;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.colorado.phet.waveinterference.view.WaveChartGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class SoundSimulationPanel
extends WaveInterferenceCanvas
implements ModelElement {
    private SoundModule soundModule;
    private IntensityReaderSet intensityReaderSet;
    private SlitPotentialGraphic slitPotentialGraphic;
    private MeasurementToolSet measurementToolSet;
    private SoundWaveGraphic soundWaveGraphic;
    private MultiOscillator multiOscillator;
    private SpeakerControlPanelPNode speakerControlPanelPNode;
    private WaveModelGraphic waveModelGraphic;
    private VerticalConnector verticalConnector;
    private ImageOscillatorPNode primarySpeaker;
    private ImageOscillatorPNode secondarySpeaker;
    private WaveChartGraphic waveChartGraphic;
    private ExpandableWaveChart expandableWaveChart;
    private PressureWaveGraphic pressureWaveGraphic;
    private RotationWaveGraphic rotationWaveGraphic;
    private RotationGlyph rotationGlyph;
    private CrossSectionGraphic crossSectionGraphic;
    private WaveInterferenceScreenUnits screenUnits;
    private CompositeWallPotentialGraphic wallPotentialGraphic;

    public SoundSimulationPanel(SoundModule soundModule) {
        this.soundModule = soundModule;
        MutableColor mutableColor = new MutableColor(Color.white);
        IndexColorMap indexColorMap = new IndexColorMap(this.getLattice(), mutableColor);
        this.waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 8, 8, indexColorMap);
        this.pressureWaveGraphic = new PressureWaveGraphic(this.getLattice(), this.waveModelGraphic.getLatticeScreenCoordinates(), soundModule.getSlitPotential());
        this.pressureWaveGraphic.setMaxVelocity(3.0);
        this.pressureWaveGraphic.setOffsetDX(-super.getWaveModelGraphicOffset().getX(), -super.getWaveModelGraphicOffset().getY());
        this.soundWaveGraphic = new SoundWaveGraphic(this.waveModelGraphic, this.pressureWaveGraphic);
        this.soundWaveGraphic.addListener(new SoundWaveGraphic.Listener(){

            public void viewChanged() {
                SoundSimulationPanel.this.updateRotationGlyphColor();
            }

            public void viewTypeChanged() {
            }
        });
        this.rotationGlyph = new RotationGlyph();
        this.rotationGlyph.synchronizeDepthSize(this.waveModelGraphic);
        this.updateRotationGlyphColor();
        this.rotationWaveGraphic = new RotationWaveGraphic3D(this.soundWaveGraphic.getWaveModelGraphic(), this.soundWaveGraphic, this.rotationGlyph);
        this.rotationWaveGraphic.setOffset(super.getWaveModelGraphicOffset());
        this.rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                SoundSimulationPanel.this.angleChanged();
            }
        });
        this.addScreenChild(this.rotationWaveGraphic);
        this.wallPotentialGraphic = new CompositeWallPotentialGraphic(this, soundModule.getWallPotentials(), this.getLatticeScreenCoordinates(), this.rotationWaveGraphic);
        this.addScreenChild(this.wallPotentialGraphic);
        this.primarySpeaker = new OscillatingSpeakerGraphic(this, soundModule.getPrimaryOscillator(), this.getLatticeScreenCoordinates());
        this.secondarySpeaker = new OscillatingSpeakerGraphic(this, soundModule.getSecondaryOscillator(), this.getLatticeScreenCoordinates());
        this.addScreenChild(this.primarySpeaker);
        this.addScreenChild(this.secondarySpeaker);
        this.multiOscillator = new MultiOscillator(this.getWaveModel(), this.primarySpeaker, soundModule.getPrimaryOscillator(), this.secondarySpeaker, soundModule.getSecondaryOscillator());
        this.slitPotentialGraphic = new SlitPotentialGraphic(soundModule.getSlitPotential(), this.waveModelGraphic.getLatticeScreenCoordinates());
        this.addScreenChild(this.slitPotentialGraphic);
        this.intensityReaderSet = new IntensityReaderSet();
        this.measurementToolSet = new MeasurementToolSet(this, soundModule.getClock(), this.getLatticeScreenCoordinates(), soundModule.getWaveInterferenceModel());
        this.speakerControlPanelPNode = new SpeakerControlPanelPNode(this, soundModule.getPrimaryOscillator(), this.waveModelGraphic);
        this.addScreenChild(this.speakerControlPanelPNode);
        this.verticalConnector = new SpeakerConnectorLeftSide((PNode)this.speakerControlPanelPNode, this.primarySpeaker);
        this.addScreenChild(0, this.verticalConnector);
        this.waveChartGraphic = new WaveChartGraphic(WIStrings.getString("readout.pressure"), this.getLatticeScreenCoordinates(), this.getWaveModel(), new MutableColor(Color.black), this.getWaveInterferenceModel().getDistanceUnits(), 0.0, this.getWaveInterferenceModel().getPhysicalWidth());
        this.expandableWaveChart = new ExpandableWaveChart(this.waveChartGraphic, this.getLatticeScreenCoordinates());
        this.addScreenChild(this.expandableWaveChart);
        this.crossSectionGraphic = new CrossSectionGraphic(this.getWaveModel(), this.getLatticeScreenCoordinates());
        this.rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                SoundSimulationPanel.this.crossSectionGraphic.setVisible(SoundSimulationPanel.this.rotationWaveGraphic.isTopView());
            }
        });
        this.crossSectionGraphic.addListener(new UpdateWaveChartCrossSection(this.waveChartGraphic));
        this.soundWaveGraphic.addListener(new SoundWaveGraphic.Listener(){

            public void viewChanged() {
                SoundSimulationPanel.this.crossSectionGraphic.setColor(SoundSimulationPanel.this.soundWaveGraphic.isParticleVisible() ? Color.white : Color.black);
            }

            public void viewTypeChanged() {
            }
        });
        this.addScreenChild(this.crossSectionGraphic);
        this.addScreenChild(this.measurementToolSet);
        this.expandableWaveChart.addListener(new ExpandableWaveChart.Listener(){

            public void expansionStateChanged() {
                SoundSimulationPanel.this.crossSectionGraphic.setVisible(SoundSimulationPanel.this.expandableWaveChart.isExpanded());
            }
        });
        this.crossSectionGraphic.setVisible(this.expandableWaveChart.isExpanded());
        this.addScreenChild(this.intensityReaderSet);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SoundSimulationPanel.this.updateWaveSize();
            }

            public void componentShown(ComponentEvent componentEvent) {
                SoundSimulationPanel.this.updateWaveSize();
            }
        });
        this.screenUnits = new WaveInterferenceScreenUnits(this.getWaveInterferenceModel().getUnits(), this.getLatticeScreenCoordinates());
        this.updateWaveSize();
        ThisSideUpWrapper thisSideUpWrapper = new ThisSideUpWrapper(this.rotationGlyph, this.getLatticeScreenCoordinates(), this.getLattice());
        this.addScreenChild(thisSideUpWrapper);
        SoundWaveGraphicRadioControl soundWaveGraphicRadioControl = new SoundWaveGraphicRadioControl(this.soundWaveGraphic);
        final PSwing pSwing = new PSwing(new ShinyPanel(soundWaveGraphicRadioControl));
        this.addScreenChild(pSwing);
        this.getLatticeScreenCoordinates().addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                pSwing.setOffset(SoundSimulationPanel.this.getLatticeScreenCoordinates().getScreenRect().getMaxX(), SoundSimulationPanel.this.getLatticeScreenCoordinates().getScreenRect().getCenterY() - pSwing.getFullBounds().getHeight() / 2.0);
            }
        });
        this.addScreenChild(new WaveSizeButtonPSwing(this.rotationWaveGraphic, this));
    }

    private void updateRotationGlyphColor() {
        this.rotationGlyph.setColors(this.soundWaveGraphic.isParticleVisible() ? new Color(40, 40, 40) : Color.darkGray, this.soundWaveGraphic.isParticleVisible() ? Color.black : Color.gray);
    }

    private void angleChanged() {
        if (this.rotationWaveGraphic.isTopView()) {
            this.slitPotentialGraphic.setVisible(true);
            this.setAsymmetricFeaturesEnabled(true);
        } else {
            this.slitPotentialGraphic.setVisible(false);
            this.setAsymmetricFeaturesEnabled(false);
        }
    }

    private void setAsymmetricFeaturesEnabled(boolean bl) {
        this.soundModule.setAsymmetricFeaturesEnabled(bl);
    }

    private WaveInterferenceModel getWaveInterferenceModel() {
        return this.soundModule.getWaveInterferenceModel();
    }

    protected void updateWaveSize() {
        if (this.getHeight() > 0) {
            double d = super.getWaveModelGraphicOffset().getY();
            double d2 = super.isWaveMaximized() ? 5.0 : this.waveChartGraphic.getChartHeight();
            double d3 = (double)this.getLayoutHeight() - d - d2;
            int n = (int)(d3 / (double)this.getWaveModel().getHeight());
            this.waveModelGraphic.setCellDimensions(n, n);
        }
    }

    public MultiOscillator getMultiOscillator() {
        return this.multiOscillator;
    }

    private Lattice2D getLattice() {
        return this.getWaveModel().getLattice();
    }

    private WaveModel getWaveModel() {
        return this.soundModule.getWaveModel();
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.soundWaveGraphic.getLatticeScreenCoordinates();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.intensityReaderSet;
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.measurementToolSet;
    }

    public void stepInTime(double d) {
        this.soundWaveGraphic.update();
        this.intensityReaderSet.update();
        this.primarySpeaker.update();
        this.secondarySpeaker.update();
        this.expandableWaveChart.updateChart();
    }

    public SoundWaveGraphic getSoundWaveGraphic() {
        return this.soundWaveGraphic;
    }

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.rotationWaveGraphic;
    }

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.screenUnits;
    }

    public void reset() {
        this.rotationWaveGraphic.reset();
        this.primarySpeaker.reset();
        this.secondarySpeaker.reset();
        this.intensityReaderSet.reset();
        this.expandableWaveChart.reset();
        this.multiOscillator.reset();
        this.measurementToolSet.reset();
        this.soundWaveGraphic.reset();
        this.wallPotentialGraphic.reset();
    }
}

