/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.SoundWaveGraphic;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.VerticalLayoutPanelWithDisable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class SoundWaveGraphicRadioControl
extends VerticalLayoutPanelWithDisable {
    private SoundWaveGraphic soundWaveGraphic;
    private JRadioButton grayscale;
    private JRadioButton particles;

    public SoundWaveGraphicRadioControl(final SoundWaveGraphic soundWaveGraphic) {
        this.soundWaveGraphic = soundWaveGraphic;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.grayscale = new JRadioButton(WIStrings.getString("sound.grayscale"), soundWaveGraphic.isGrayscaleVisible());
        this.grayscale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundWaveGraphicRadioControl.this.update();
            }
        });
        this.particles = new JRadioButton(WIStrings.getString("sound.particles"), soundWaveGraphic.isParticleVisible());
        this.particles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SoundWaveGraphicRadioControl.this.update();
            }
        });
        buttonGroup.add(this.grayscale);
        buttonGroup.add(this.particles);
        this.add(this.grayscale);
        this.add(this.particles);
        soundWaveGraphic.addListener(new SoundWaveGraphic.Listener(){

            public void viewChanged() {
            }

            public void viewTypeChanged() {
                SoundWaveGraphicRadioControl.this.grayscale.setSelected(soundWaveGraphic.isGrayscaleVisible());
                SoundWaveGraphicRadioControl.this.particles.setSelected(soundWaveGraphic.isParticleVisible());
            }
        });
        this.update();
    }

    private void update() {
        boolean bl = this.grayscale.isSelected();
        boolean bl2 = this.particles.isSelected();
        this.soundWaveGraphic.setGrayscaleVisible(bl);
        this.soundWaveGraphic.setParticlesVisible(bl2);
    }
}

