/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.ResizeHandler;
import edu.colorado.phet.waveinterference.SpeakerControlPanel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SpeakerControlPanelPNode
extends PNode {
    private Oscillator oscillator;
    private WaveModelGraphic waveModelGraphic;

    public SpeakerControlPanelPNode(PSwingCanvas pSwingCanvas, Oscillator oscillator, WaveModelGraphic waveModelGraphic) {
        this.oscillator = oscillator;
        this.waveModelGraphic = waveModelGraphic;
        SpeakerControlPanel speakerControlPanel = new SpeakerControlPanel(oscillator);
        PSwing pSwing = new PSwing(new ShinyPanel(speakerControlPanel));
        ResizeHandler.getInstance().setResizable(pSwingCanvas, pSwing, 0.9);
        this.addChild(pSwing);
        waveModelGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SpeakerControlPanelPNode.this.updateLocation();
            }
        });
        this.updateLocation();
    }

    private void updateLocation() {
        this.setOffset(0.0, this.waveModelGraphic.getLatticeScreenCoordinates().getScreenRect().getMaxY() - this.getFullBounds().getHeight());
    }
}

