/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.ThisSideUpGraphic;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import java.awt.geom.Point2D;

public class ThisSideUpWrapper
extends PhetPNode {
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private Lattice2D lattice2D;
    private ThisSideUpGraphic thisSideUpGraphic;
    private RotationGlyph rotationGlyph;

    public ThisSideUpWrapper(RotationGlyph rotationGlyph, LatticeScreenCoordinates latticeScreenCoordinates, Lattice2D lattice2D) {
        this.rotationGlyph = rotationGlyph;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.lattice2D = lattice2D;
        this.thisSideUpGraphic = new ThisSideUpGraphic();
        this.addChild(this.thisSideUpGraphic);
        rotationGlyph.addListener(new RotationGlyph.Listener(){

            public void angleChanged() {
                ThisSideUpWrapper.this.update();
            }
        });
        this.update();
    }

    public void update() {
        this.thisSideUpGraphic.setAngle(this.rotationGlyph.getAngle());
        Point2D point2D = this.getLatticeScreenCoordinates().toScreenCoordinates(this.getLattice().getWidth(), this.getLattice().getHeight() / 2);
        point2D = new Point2D.Double(point2D.getX() - this.getFullBounds().getWidth() * 2.0, point2D.getY());
        this.setOffset(point2D);
    }

    private Lattice2D getLattice() {
        return this.lattice2D;
    }

    private LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.latticeScreenCoordinates;
    }
}

