/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.AddWallPotentialButton;
import edu.colorado.phet.waveinterference.ResetModuleControl;
import edu.colorado.phet.waveinterference.VerticalSeparator;
import edu.colorado.phet.waveinterference.WaterModule;
import edu.colorado.phet.waveinterference.WaveInterferenceControlPanel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.DetectorSetControlPanel;
import edu.colorado.phet.waveinterference.view.MeasurementControlPanel;
import edu.colorado.phet.waveinterference.view.MultiDripControlPanel;
import edu.colorado.phet.waveinterference.view.SlitControlPanel;
import edu.colorado.phet.waveinterference.view.WaveRotateControl;

public class WaterControlPanel
extends WaveInterferenceControlPanel {
    private WaterModule waterModule;

    public WaterControlPanel(WaterModule waterModule) {
        this.waterModule = waterModule;
        this.addControl(new MeasurementControlPanel(waterModule.getMeasurementToolSet()));
        this.addControl(new DetectorSetControlPanel(WIStrings.getString("water.level"), waterModule.getIntensityReaderSet(), waterModule.getWaterSimulationPanel(), waterModule.getWaveModel(), waterModule.getLatticeScreenCoordinates(), waterModule.getClock()));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new ResetModuleControl(waterModule));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new WaveRotateControl(waterModule.getRotationWaveGraphic()));
        this.addVerticalSpace();
        this.addControl(new MultiDripControlPanel(waterModule.getMultiDrip(), waterModule.getScreenUnits()));
        this.addControl(new SlitControlPanel(waterModule.getSlitPotential(), waterModule.getScreenUnits()));
        this.addControl(new AddWallPotentialButton(waterModule.getWaveInterferenceModel()));
    }
}

