/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.WaterControlPanel;
import edu.colorado.phet.waveinterference.WaterSimulationPanel;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveInterferenceModule;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiFaucetDrip;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;

public class WaterModule
extends WaveInterferenceModule {
    private WaterSimulationPanel waterSimulationPanel;
    private WaveInterferenceModel waveInterferenceModel = new WaterModel();
    private WaterControlPanel waterControlPanel;

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.waterSimulationPanel.getScreenUnits();
    }

    public CompositePotential getWallPotentials() {
        return this.waveInterferenceModel.getWallPotentials();
    }

    public WaterModule() {
        super(WIStrings.getString("module.water"));
        this.waterSimulationPanel = new WaterSimulationPanel(this);
        this.waterControlPanel = new WaterControlPanel(this);
        this.addModelElement(this.waveInterferenceModel);
        this.addModelElement(this.waterSimulationPanel);
        this.setSimulationPanel(this.waterSimulationPanel);
        this.setControlPanel(this.waterControlPanel);
        this.waveInterferenceModel.setInitialConditions();
    }

    public WaveModel getWaveModel() {
        return this.waveInterferenceModel.getWaveModel();
    }

    public SlitPotential getSlitPotential() {
        return this.waveInterferenceModel.getSlitPotential();
    }

    public Oscillator getSecondaryOscillator() {
        return this.waveInterferenceModel.getSecondaryOscillator();
    }

    public Oscillator getPrimaryOscillator() {
        return this.waveInterferenceModel.getPrimaryOscillator();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.waterSimulationPanel.getIntensityReaderSet();
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.waterSimulationPanel.getMeasurementToolSet();
    }

    public WaterSimulationPanel getWaterSimulationPanel() {
        return this.waterSimulationPanel;
    }

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.waterSimulationPanel.getRotationWaveGraphic();
    }

    public MultiFaucetDrip getMultiDrip() {
        return this.waterSimulationPanel.getMultiDrip();
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.waterSimulationPanel.getLatticeScreenCoordinates();
    }

    public WaveInterferenceModel getWaveInterferenceModel() {
        return this.waveInterferenceModel;
    }

    public void resetAll() {
        super.resetAll();
        this.getWaveInterferenceModel().reset();
        this.waterSimulationPanel.reset();
    }

    static class WaterModel
    extends WaveInterferenceModel {
        public WaterModel() {
            this.setDistanceUnits("cm");
            this.setPhysicalSize(10.0, 10.0);
        }
    }
}

