/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.waveinterference.BarrierSideView;
import edu.colorado.phet.waveinterference.ResizeHandler;
import edu.colorado.phet.waveinterference.ThisSideUpWrapper;
import edu.colorado.phet.waveinterference.UpdateWaveChartCrossSection;
import edu.colorado.phet.waveinterference.WaterModule;
import edu.colorado.phet.waveinterference.WaveInterferenceCanvas;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveSizeButtonPSwing;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.waveinterference.tests.ExpandableWaveChart;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.CompositeWallPotentialGraphic;
import edu.colorado.phet.waveinterference.view.CrossSectionGraphic;
import edu.colorado.phet.waveinterference.view.FaucetConnector;
import edu.colorado.phet.waveinterference.view.FaucetControlPanel;
import edu.colorado.phet.waveinterference.view.FaucetControlPanelPNode;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiFaucetDrip;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.RotationFaucetGraphic;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.colorado.phet.waveinterference.view.TopViewBarrierVisibility;
import edu.colorado.phet.waveinterference.view.WaveChartGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.colorado.phet.waveinterference.view.WaveSideViewFull;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WaterSimulationPanel
extends WaveInterferenceCanvas
implements ModelElement,
TopViewBarrierVisibility {
    private WaterModule waterModule;
    private RotationWaveGraphic rotationWaveGraphic;
    private IntensityReaderSet intensityReaderSet;
    private SlitPotentialGraphic slitPotentialGraphic;
    private MeasurementToolSet measurementToolSet;
    private FaucetGraphic primaryFaucetGraphic;
    private FaucetGraphic secondaryFaucetGraphic;
    private MultiFaucetDrip multiFaucetDrip;
    private FaucetControlPanelPNode faucetControlPanelPNode;
    private MutableColor waterColor = new MutableColor(new Color(37, 179, 255));
    private FaucetConnector faucetConnector;
    private WaveModel viewableModel;
    private ExpandableWaveChart expandableWaveChart;
    private WaveChartGraphic waveChartGraphic;
    private CrossSectionGraphic crossSectionGraphic;
    private WaveInterferenceScreenUnits screenUnits;
    private WaveModelGraphic waveModelGraphic;
    private CompositeWallPotentialGraphic wallPotentialGraphic;

    public WaterSimulationPanel(WaterModule waterModule) {
        this.waterModule = waterModule;
        this.viewableModel = waterModule.getWaveModel();
        this.waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 6, 6, new IndexColorMap(this.getLattice(), this.waterColor));
        WaveSideViewFull waveSideViewFull = new WaveSideViewFull(this.getWaveModel(), this.waveModelGraphic.getLatticeScreenCoordinates());
        waveSideViewFull.setStrokeColor(this.waterColor.getColor().darker());
        waveSideViewFull.setBodyColor(this.waterColor.getColor());
        RotationGlyph rotationGlyph = new RotationGlyph(this.waterColor);
        this.rotationWaveGraphic = new RotationWaveGraphic(this.waveModelGraphic, waveSideViewFull, rotationGlyph);
        this.rotationWaveGraphic.setOffset(super.getWaveModelGraphicOffset());
        this.rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                WaterSimulationPanel.this.angleChanged();
            }
        });
        this.addScreenChild(new BarrierSideView(waterModule.getSlitPotential(), this.getLatticeScreenCoordinates(), waveSideViewFull));
        this.addScreenChild(this.rotationWaveGraphic);
        this.wallPotentialGraphic = new CompositeWallPotentialGraphic(this, waterModule.getWallPotentials(), this.getLatticeScreenCoordinates(), this.rotationWaveGraphic);
        this.addScreenChild(this.wallPotentialGraphic);
        this.rotationWaveGraphic.setPickable(false);
        this.rotationWaveGraphic.setChildrenPickable(false);
        this.primaryFaucetGraphic = new RotationFaucetGraphic(this, this.getWaveModel(), waterModule.getPrimaryOscillator(), this.getLatticeScreenCoordinates(), this.rotationWaveGraphic);
        this.addScreenChild(this.primaryFaucetGraphic);
        this.secondaryFaucetGraphic = new RotationFaucetGraphic(this, this.getWaveModel(), waterModule.getSecondaryOscillator(), this.getLatticeScreenCoordinates(), this.rotationWaveGraphic);
        this.secondaryFaucetGraphic.setEnabled(false);
        this.addScreenChild(this.secondaryFaucetGraphic);
        this.slitPotentialGraphic = new SlitPotentialGraphic(this, waterModule.getSlitPotential(), this.getLatticeScreenCoordinates());
        this.addScreenChild(this.slitPotentialGraphic);
        this.intensityReaderSet = new IntensityReaderSet();
        this.measurementToolSet = new MeasurementToolSet(this, waterModule.getClock(), this.getLatticeScreenCoordinates(), this.getWaveInterferenceModel());
        this.multiFaucetDrip = new MultiFaucetDrip(this.getWaveModel(), this.primaryFaucetGraphic, this.secondaryFaucetGraphic);
        this.faucetControlPanelPNode = new FaucetControlPanelPNode(this, new ShinyPanel(new FaucetControlPanel(waterModule.getPrimaryOscillator(), this.getPrimaryFaucetGraphic())), this.getPrimaryFaucetGraphic(), this.waveModelGraphic);
        ResizeHandler.getInstance().setResizable(this, this.faucetControlPanelPNode, 0.9);
        this.addScreenChild(this.faucetControlPanelPNode);
        this.faucetConnector = new FaucetConnector(this.faucetControlPanelPNode, this.primaryFaucetGraphic);
        this.addScreenChild(0, this.faucetConnector);
        this.waveChartGraphic = new WaveChartGraphic(WIStrings.getString("water.level"), this.getLatticeScreenCoordinates(), this.getWaveModel(), this.waterColor, this.getWaveInterferenceModel().getDistanceUnits(), 0.0, this.getWaveInterferenceModel().getPhysicalWidth());
        this.expandableWaveChart = new ExpandableWaveChart(this.waveChartGraphic, this.getLatticeScreenCoordinates());
        this.addScreenChild(this.expandableWaveChart);
        this.crossSectionGraphic = new CrossSectionGraphic(this.getWaveModel(), this.getLatticeScreenCoordinates());
        this.crossSectionGraphic.addListener(new UpdateWaveChartCrossSection(this.waveChartGraphic));
        this.addScreenChild(this.crossSectionGraphic);
        this.addScreenChild(this.measurementToolSet);
        this.addScreenChild(this.intensityReaderSet);
        this.expandableWaveChart.addListener(new ExpandableWaveChart.Listener(){

            public void expansionStateChanged() {
                WaterSimulationPanel.this.updateCrossSectionGraphicVisible();
            }
        });
        this.updateCrossSectionGraphicVisible();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                WaterSimulationPanel.this.updateWaveSize();
            }

            public void componentShown(ComponentEvent componentEvent) {
                WaterSimulationPanel.this.updateWaveSize();
            }
        });
        this.screenUnits = new WaveInterferenceScreenUnits(this.getWaveInterferenceModel().getUnits(), this.getLatticeScreenCoordinates());
        this.updateWaveSize();
        ThisSideUpWrapper thisSideUpWrapper = new ThisSideUpWrapper(rotationGlyph, this.getLatticeScreenCoordinates(), this.getLattice());
        this.addScreenChild(thisSideUpWrapper);
        this.addScreenChild(new WaveSizeButtonPSwing(this.rotationWaveGraphic, this));
    }

    private WaveInterferenceModel getWaveInterferenceModel() {
        return this.waterModule.getWaveInterferenceModel();
    }

    private void updateCrossSectionGraphicVisible() {
        this.crossSectionGraphic.setVisible(this.expandableWaveChart.isExpanded() && this.rotationWaveGraphic.isTopView());
    }

    protected void updateWaveSize() {
        if (this.getHeight() > 0) {
            double d = super.getWaveModelGraphicOffset().getY();
            double d2 = this.isWaveMaximized() ? 5.0 : this.waveChartGraphic.getChartHeight();
            double d3 = (double)super.getLayoutHeight() - d - d2;
            int n = (int)(d3 / (double)this.getWaveModel().getHeight());
            this.rotationWaveGraphic.setCellSize(n);
            double d4 = this.rotationWaveGraphic.getFullBounds().getHeight() + this.faucetControlPanelPNode.getFullBounds().getHeight() + d + d2;
        }
    }

    public boolean isTopVisible() {
        return this.rotationWaveGraphic.isTopView();
    }

    private void angleChanged() {
        if (this.isTopVisible()) {
            this.slitPotentialGraphic.setVisible(true);
            this.slitPotentialGraphic.update();
        } else {
            this.slitPotentialGraphic.setVisible(false);
        }
        this.updateCrossSectionGraphicVisible();
        this.intensityReaderSet.setConstrainedToMidline(this.rotationWaveGraphic.isSideView());
    }

    public MultiFaucetDrip getMultiDrip() {
        return this.multiFaucetDrip;
    }

    private Lattice2D getLattice() {
        return this.getWaveModel().getLattice();
    }

    private WaveModel getWaveModel() {
        return this.viewableModel;
    }

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.rotationWaveGraphic;
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.rotationWaveGraphic.getLatticeScreenCoordinates();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.intensityReaderSet;
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.measurementToolSet;
    }

    public FaucetGraphic getPrimaryFaucetGraphic() {
        return this.primaryFaucetGraphic;
    }

    public void stepInTime(double d) {
        this.rotationWaveGraphic.update();
        this.primaryFaucetGraphic.step();
        this.secondaryFaucetGraphic.step();
        this.intensityReaderSet.update();
        this.expandableWaveChart.updateChart();
    }

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.screenUnits;
    }

    public void reset() {
        this.rotationWaveGraphic.reset();
        this.primaryFaucetGraphic.reset();
        this.secondaryFaucetGraphic.reset();
        this.intensityReaderSet.reset();
        this.expandableWaveChart.reset();
        this.multiFaucetDrip.reset();
        this.measurementToolSet.reset();
        this.wallPotentialGraphic.reset();
    }
}

