/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.MultiStateButton;
import edu.colorado.phet.waveinterference.Maximizable;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class WaveSizeButton
extends MultiStateButton {
    private RotationWaveGraphic rotationWaveGraphic;
    private Maximizable maximizable;
    private String BIG_KEY = "big";
    private String SMALL_KEY = "small";

    public WaveSizeButton(RotationWaveGraphic rotationWaveGraphic, final Maximizable maximizable) {
        this.rotationWaveGraphic = rotationWaveGraphic;
        this.maximizable = maximizable;
        if (!PhetUtilities.isMacintosh()) {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
        this.addMode(this.BIG_KEY, null, new ImageIcon(PhetCommonResources.getMaximizeButtonImage()));
        this.addActionListener(this.BIG_KEY, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                maximizable.setWaveMaximized(true);
            }
        });
        this.addMode(this.SMALL_KEY, null, new ImageIcon(PhetCommonResources.getMinimizeButtonImage()));
        this.addActionListener(this.SMALL_KEY, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                maximizable.setWaveMaximized(false);
            }
        });
    }
}

