/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.Potential;

public class ClassicalWavePropagator {
    private Lattice2D last2;
    private Lattice2D last;
    private Potential potential;

    public ClassicalWavePropagator(Potential potential) {
        this.potential = potential;
    }

    public void propagate(Lattice2D lattice2D) {
        float f = 0.0f;
        if (this.last == null || this.last2 == null || !lattice2D.getSize().equals(this.last.getSize()) || !lattice2D.getSize().equals(this.last2.getSize())) {
            this.last = lattice2D.copy();
            this.last2 = lattice2D.copy();
            return;
        }
        float f2 = 0.5f;
        float f3 = f2 * f2;
        int n = lattice2D.getWidth() - 1;
        int n2 = lattice2D.getHeight() - 1;
        for (int i = 1; i < n; ++i) {
            for (int j = 1; j < n2; ++j) {
                if (this.potential.getPotential(i, j, 0) != 0.0) {
                    lattice2D.setValue(i, j, 0.0f);
                    continue;
                }
                f = f3 * (this.last.wavefunction[i + 1][j] + this.last.wavefunction[i - 1][j] + this.last.wavefunction[i][j + 1] + this.last.wavefunction[i][j - 1] + this.last.wavefunction[i][j] * -4.0f);
                lattice2D.setValue(i, j, this.last.wavefunction[i][j] * 2.0f - this.last2.wavefunction[i][j] + f);
            }
        }
        this.dampHorizontal(lattice2D, 0, 1);
        this.dampHorizontal(lattice2D, lattice2D.getHeight() - 1, -1);
        this.dampVertical(lattice2D, 0, 1);
        this.dampVertical(lattice2D, lattice2D.getWidth() - 1, -1);
        this.last.copyTo(this.last2);
        lattice2D.copyTo(this.last);
    }

    private void dampHorizontal(Lattice2D lattice2D, int n, int n2) {
        for (int i = 0; i < lattice2D.getWidth(); ++i) {
            lattice2D.setValue(i, n, this.last2.getValue(i, n + n2));
        }
    }

    private void dampVertical(Lattice2D lattice2D, int n, int n2) {
        for (int i = 0; i < lattice2D.getHeight(); ++i) {
            lattice2D.setValue(n, i, this.last2.getValue(n + n2, i));
        }
    }

    public void setBoundaryCondition(int n, int n2, float f) {
        if (this.last != null) {
            this.last.setValue(n, n2, f);
        }
        if (this.last2 != null) {
            this.last2.setValue(n, n2, f);
        }
    }

    public Lattice2D getLast() {
        return this.last;
    }

    public void setSize(int n, int n2) {
        if (this.last != null) {
            this.last.setSize(n, n2);
        }
        if (this.last2 != null) {
            this.last2.setSize(n, n2);
        }
    }

    public void setPotential(Potential potential) {
        this.potential = potential;
    }

    public void clear() {
        if (this.last != null) {
            this.last.clear();
        }
        if (this.last2 != null) {
            this.last2.clear();
        }
    }
}

