/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.ClassicalWavePropagator;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.Potential;

public class DampedClassicalWavePropagator
extends ClassicalWavePropagator {
    private int dampX;
    private int dampY;
    private Lattice2D largeLattice;
    double[] dampCoefficients = new double[]{0.999, 0.999, 0.998, 0.995, 0.99, 0.95, 0.9, 0.8, 0.7, 0.5, 0.25, 0.2};

    public DampedClassicalWavePropagator(Potential potential, int n, int n2) {
        super(potential);
        this.dampX = n;
        this.dampY = n2;
    }

    public Lattice2D getLargeLattice() {
        return this.largeLattice;
    }

    public int getDampX() {
        return this.dampX;
    }

    public int getDampY() {
        return this.dampY;
    }

    public void setPotential(Potential potential) {
        super.setPotential(new PaddedPotential(potential));
    }

    public void setBoundaryCondition(int n, int n2, float f) {
        super.setBoundaryCondition(n + this.dampX, n2 + this.dampY, f);
    }

    public void clearOffscreenLatticeValue(int n, int n2) {
        this.largeLattice.setValue(n, n2, 0.0f);
        super.setBoundaryCondition(n, n2, 0.0f);
    }

    public void propagate(Lattice2D lattice2D) {
        int n;
        int n2;
        if (this.largeLattice == null || this.largeLattice.getWidth() != lattice2D.getWidth() || this.largeLattice.getHeight() != lattice2D.getHeight()) {
            this.largeLattice = new Lattice2D(lattice2D.getWidth() + this.dampX * 2, lattice2D.getHeight() + this.dampY * 2);
        }
        for (n2 = 0; n2 < lattice2D.getWidth(); ++n2) {
            for (n = 0; n < lattice2D.getHeight(); ++n) {
                this.largeLattice.setValue(n2 + this.dampX, n + this.dampY, lattice2D.getValue(n2, n));
            }
        }
        super.propagate(this.largeLattice);
        for (n2 = 0; n2 < 1; ++n2) {
            this.dampScale(this.largeLattice);
        }
        for (n2 = 0; n2 < lattice2D.getWidth(); ++n2) {
            for (n = 0; n < lattice2D.getHeight(); ++n) {
                lattice2D.setValue(n2, n, this.largeLattice.getValue(n2 + this.dampX, n + this.dampY));
            }
        }
    }

    private void dampVertical(Lattice2D lattice2D, int n, int n2, int n3) {
        for (int i = 0; i < lattice2D.getHeight(); ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = n3 - j;
                float f = this.getDamp(n4);
                int n5 = n + j * n2;
                lattice2D.setValue(n5, i, lattice2D.getValue(n5, i) * f);
                this.getLast().setValue(n5, i, this.getLast().getValue(n5, i) * f);
            }
        }
    }

    private void dampHorizontal(Lattice2D lattice2D, int n, int n2, int n3) {
        for (int i = 0; i < lattice2D.getWidth(); ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = n3 - j;
                float f = this.getDamp(n4);
                int n5 = n + j * n2;
                lattice2D.setValue(i, n5, lattice2D.getValue(i, n5) * f);
                this.getLast().setValue(i, n5, this.getLast().getValue(i, n5) * f);
            }
        }
    }

    private void dampScale(Lattice2D lattice2D) {
        this.dampVertical(lattice2D, 0, 1, this.dampY / 2);
        this.dampVertical(lattice2D, lattice2D.getWidth() - 1, -1, this.dampY / 2);
        this.dampHorizontal(lattice2D, 0, 1, this.dampX / 2);
        this.dampHorizontal(lattice2D, lattice2D.getHeight() - 1, -1, this.dampX / 2);
    }

    private float getDamp(int n) {
        return (float)(1.0 - (double)n * 1.0E-4);
    }

    class PaddedPotential
    implements Potential {
        private Potential potential;

        public PaddedPotential(Potential potential) {
            this.potential = potential;
        }

        public double getPotential(int n, int n2, int n3) {
            return this.potential.getPotential(n - DampedClassicalWavePropagator.this.dampX, n2 - DampedClassicalWavePropagator.this.dampY, n3);
        }
    }
}

