/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.WaveModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Oscillator {
    private double period = 2.0;
    private int oscillatorRadius = 2;
    private WaveModel waveModel;
    private int x;
    private int y;
    private double amplitude = 1.0;
    private double time;
    private boolean enabled = true;
    private ArrayList listeners = new ArrayList();
    private Oscillator prototype;
    private boolean pulseEnabled = false;
    private double phase = 0.0;

    private Oscillator(WaveModel waveModel, boolean bl) {
        this(waveModel);
    }

    public Oscillator(WaveModel waveModel) {
        this(waveModel, 8, waveModel.getHeight() / 2);
    }

    public Oscillator(WaveModel waveModel, int n, int n2) {
        this.waveModel = waveModel;
        this.setLocation(n, n2);
    }

    public void setTime(double d) {
        this.time = d;
        if (this.isEnabled()) {
            double d2 = this.getValue();
            for (int i = this.x - this.oscillatorRadius; i <= this.x + this.oscillatorRadius; ++i) {
                for (int j = this.y - this.oscillatorRadius; j <= this.y + this.oscillatorRadius; ++j) {
                    if (!(Math.sqrt((i - this.x) * (i - this.x) + (j - this.y) * (j - this.y)) < (double)this.oscillatorRadius) || !this.waveModel.containsLocation(i, j)) continue;
                    this.waveModel.setSourceValue(i, j, (float)d2);
                }
            }
        }
        if (this.pulseEnabled && this.getCosArg() + this.phase >= Math.PI * 2) {
            this.pulseEnabled = false;
            this.phase = 0.0;
            this.setEnabled(false);
        }
    }

    public void firePulse() {
        if (!this.pulseEnabled) {
            this.setEnabled(true);
            this.phase = -this.getCosArg() + 1.5707963267948966;
            this.pulseEnabled = true;
        }
    }

    public double getValue() {
        return this.amplitude * Math.cos(this.getCosArg() + this.phase);
    }

    private double getCosArg() {
        return Math.PI * 2 * this.getFrequency() * this.time;
    }

    public int getRadius() {
        return this.oscillatorRadius;
    }

    public void setRadius(int n) {
        this.oscillatorRadius = n;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double d) {
        this.period = d;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.locationChanged();
        }
    }

    public double getFrequency() {
        return 1.0 / this.period;
    }

    public void setFrequency(double d) {
        this.period = 1.0 / d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.frequencyChanged();
        }
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.amplitudeChanged();
        }
    }

    public int getCenterX() {
        return this.x;
    }

    public int getCenterY() {
        return this.y;
    }

    public double getTime() {
        return this.time;
    }

    public void setEnabled(boolean bl) {
        if (!this.enabled == bl) {
            this.enabled = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.enabledStateChanged();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.getCenterX(), this.getCenterY());
    }

    public void reset() {
        this.setAmplitude(this.prototype.getAmplitude());
        this.setEnabled(this.prototype.isEnabled());
        this.setFrequency(this.prototype.getFrequency());
        this.setLocation(this.prototype.getCenterX(), this.prototype.getCenterY());
        this.setPeriod(this.prototype.getPeriod());
        this.setRadius(this.prototype.getRadius());
        this.setTime(this.prototype.getTime());
    }

    public void saveState() {
        this.prototype = new Oscillator(this.waveModel, true);
        this.prototype.setAmplitude(this.getAmplitude());
        this.prototype.setEnabled(this.isEnabled());
        this.prototype.setFrequency(this.getFrequency());
        this.prototype.setLocation(this.getCenterX(), this.getCenterY());
        this.prototype.setPeriod(this.getPeriod());
        this.prototype.setTime(this.time);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static class Adapter
    implements Listener {
        public void enabledStateChanged() {
        }

        public void locationChanged() {
        }

        public void frequencyChanged() {
        }

        public void amplitudeChanged() {
        }
    }

    public static interface Listener {
        public void enabledStateChanged();

        public void locationChanged();

        public void frequencyChanged();

        public void amplitudeChanged();
    }
}

