/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.Potential;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class VerticalBarrier
implements Potential {
    private int gridWidth;
    private int gridHeight;
    private int x;
    private int thickness;
    private int slitSize;
    private int slitSeparation;
    private double potential;
    private Potential potentialDelegate;
    private boolean inverse = false;
    private ArrayList listeners = new ArrayList();

    public VerticalBarrier(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.gridWidth = n;
        this.gridHeight = n2;
        this.x = n3;
        this.thickness = n4;
        this.slitSize = n5;
        this.slitSeparation = n6;
        this.potential = d;
        this.update();
    }

    public abstract Rectangle[] getRectangleBarriers();

    protected int round(double d) {
        return (int)d;
    }

    protected void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.slitChanged();
        }
    }

    protected void update() {
    }

    protected void setPotentialDelegate(Potential potential) {
        this.potentialDelegate = potential;
    }

    public double getPotential(int n, int n2, int n3) {
        return this.potentialDelegate.getPotential(n, n2, n3);
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getSlitSize() {
        return this.slitSize;
    }

    public int getSlitSeparation() {
        return this.slitSeparation;
    }

    public double getPotential() {
        return this.potential;
    }

    public boolean getInverse() {
        return this.inverse;
    }

    public static interface Listener {
        public void slitChanged();
    }
}

