/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.BarrierPotential;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.PrecomputedPotential;
import edu.colorado.phet.waveinterference.model.VerticalBarrier;
import java.awt.Rectangle;
import java.util.ArrayList;

public class VerticalDoubleSlit
extends VerticalBarrier {
    private Rectangle topSlit;
    private Rectangle bottomSlit;
    private Rectangle topBar;
    private Rectangle midBar;
    private Rectangle bottomBar;

    public VerticalDoubleSlit(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        super(n, n2, n3, n4, n5, n6, d);
    }

    protected void update() {
        int n;
        int n2 = this.getGridHeight();
        int n3 = this.getSlitSeparation();
        int n4 = n3 - (n = this.getSlitSize());
        if (n4 <= 0) {
            n4 = 1;
        }
        int n5 = n2 / 2 - n4 / 2 - n;
        int n6 = n2 - n5 - n - n4 - n;
        int n7 = this.getThickness();
        int n8 = this.getX();
        double d = this.getPotential();
        this.topBar = new Rectangle(n8, 0, n7, n5);
        this.midBar = new Rectangle(n8, n5 + n, n7, n4);
        this.bottomBar = new Rectangle(n8, this.midBar.y + this.midBar.height + n, n7, n6);
        this.topSlit = new Rectangle(n8, this.topBar.y + this.topBar.height, n7, n);
        this.bottomSlit = new Rectangle(n8, this.midBar.y + this.midBar.height, n7, n);
        CompositePotential compositePotential = new CompositePotential();
        if (super.getInverse()) {
            compositePotential.addPotential(new BarrierPotential(this.topSlit, d));
            compositePotential.addPotential(new BarrierPotential(this.bottomSlit, d));
        } else {
            compositePotential.addPotential(new BarrierPotential(this.topBar, d));
            compositePotential.addPotential(new BarrierPotential(this.midBar, d));
            compositePotential.addPotential(new BarrierPotential(this.bottomBar, d));
        }
        this.setPotentialDelegate(new PrecomputedPotential(compositePotential, this.getGridWidth(), this.getGridHeight()));
        this.notifyListeners();
    }

    public Rectangle[] getRectangleBarriers() {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        if (this.getInverse()) {
            arrayList.add(this.topSlit);
            arrayList.add(this.bottomSlit);
        } else {
            arrayList.add(this.topBar);
            arrayList.add(this.midBar);
            arrayList.add(this.bottomBar);
        }
        return arrayList.toArray(new Rectangle[0]);
    }
}

