/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.BarrierPotential;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.PrecomputedPotential;
import edu.colorado.phet.waveinterference.model.VerticalBarrier;
import java.awt.Rectangle;
import java.util.ArrayList;

public class VerticalSingleSlit
extends VerticalBarrier {
    private Rectangle slit;
    private Rectangle topBar;
    private Rectangle bottomBar;

    public VerticalSingleSlit(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        super(n, n2, n3, n4, n5, n6, d);
    }

    protected void update() {
        int n = this.getGridHeight();
        int n2 = this.getSlitSize();
        int n3 = this.getThickness();
        int n4 = this.getX();
        double d = this.getPotential();
        int n5 = this.round((double)n / 2.0);
        this.topBar = new Rectangle(n4, 0, n3, this.round((double)n5 - (double)n2 / 2.0));
        int n6 = this.round((double)n5 + (double)n2 / 2.0);
        this.bottomBar = new Rectangle(n4, n6, n3, this.getGridHeight() - n6);
        this.slit = new Rectangle(n4, this.topBar.x + this.topBar.width, n3, n2);
        CompositePotential compositePotential = new CompositePotential();
        if (super.getInverse()) {
            compositePotential.addPotential(new BarrierPotential(this.slit, d));
        } else {
            compositePotential.addPotential(new BarrierPotential(this.topBar, d));
            compositePotential.addPotential(new BarrierPotential(this.bottomBar, d));
        }
        this.setPotentialDelegate(new PrecomputedPotential(compositePotential, this.getGridWidth(), this.getGridHeight()));
        this.notifyListeners();
    }

    public Rectangle[] getRectangleBarriers() {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        if (this.getInverse()) {
            arrayList.add(this.slit);
        } else {
            arrayList.add(this.topBar);
            arrayList.add(this.bottomBar);
        }
        return arrayList.toArray(new Rectangle[0]);
    }
}

