/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.ClassicalWavePropagator;
import edu.colorado.phet.waveinterference.model.ConstantPotential;
import edu.colorado.phet.waveinterference.model.DampedClassicalWavePropagator;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.Potential;
import java.util.ArrayList;

public class WaveModel {
    private Lattice2D lattice;
    private ClassicalWavePropagator classicalWavePropagator;
    private ArrayList listeners = new ArrayList();

    public WaveModel(int n, int n2) {
        this(new Lattice2D(n, n2), 20, 20);
    }

    public WaveModel(int n, int n2, int n3, int n4) {
        this(new Lattice2D(n, n2), n3, n4);
    }

    public WaveModel(Lattice2D lattice2D, int n, int n2) {
        this.classicalWavePropagator = new DampedClassicalWavePropagator(new ConstantPotential(), n, n2);
        this.lattice = lattice2D;
    }

    public ClassicalWavePropagator getClassicalWavePropagator() {
        return this.classicalWavePropagator;
    }

    public void setSize(int n, int n2) {
        this.lattice.setSize(n, n2);
        this.classicalWavePropagator.setSize(n, n2);
        this.notifySizeChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getValue(int n, int n2) {
        return this.lattice.getValue(n, n2);
    }

    public void addListener(int n, Listener listener) {
        this.listeners.add(n, listener);
    }

    private void notifySizeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.sizeChanged();
        }
    }

    public Lattice2D getLattice() {
        return this.lattice;
    }

    public void propagate() {
        this.classicalWavePropagator.propagate(this.lattice);
    }

    public int getHeight() {
        return this.lattice.getHeight();
    }

    public void setSourceValue(int n, int n2, float f) {
        this.lattice.setValue(n, n2, f);
        this.classicalWavePropagator.setBoundaryCondition(n, n2, f);
    }

    public int getWidth() {
        return this.lattice.getWidth();
    }

    public boolean containsLocation(int n, int n2) {
        return this.lattice.containsLocation(n, n2);
    }

    public double getAverageValue(int n, int n2, int n3) {
        return this.lattice.getAverageValue(n, n2, n3);
    }

    public void setPotential(Potential potential) {
        this.classicalWavePropagator.setPotential(potential);
    }

    public void clear() {
        this.lattice.clear();
        this.classicalWavePropagator.clear();
    }

    public static interface Listener {
        public void sizeChanged();
    }
}

