/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.sound;

import edu.colorado.phet.waveinterference.sound.FourierOscillator;
import edu.colorado.phet.waveinterference.util.WIStrings;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.event.EventListenerList;

public class FourierSoundPlayer
implements Runnable {
    private static final AudioFormat.Encoding ENCODING = AudioFormat.Encoding.PCM_SIGNED;
    private FourierOscillator _oscillator;
    private SourceDataLine _sourceDataLine;
    private boolean _soundEnabled = false;
    private EventListenerList _listenerList = new EventListenerList();
    private Thread soundThread;
    private boolean active;

    public FourierSoundPlayer() throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(ENCODING, 44100.0f, 16, 2, 4, 44100.0f, false);
        this._oscillator = new FourierOscillator(0.5f, audioFormat, -1L);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this._sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
        this._sourceDataLine.open(audioFormat, 16000);
    }

    public void setSoundEnabled(boolean bl) {
        this._soundEnabled = bl;
        this._oscillator.setEnabled(bl);
        if (bl) {
            if (this.soundThread == null) {
                this.soundThread = new Thread(this);
                this.soundThread.start();
            }
            this._sourceDataLine.start();
        } else {
            this._sourceDataLine.stop();
            this._sourceDataLine.flush();
        }
    }

    public boolean isEnabled() {
        return this._soundEnabled && this.active;
    }

    public void setVolume(float f) {
        this._oscillator.setVolume(f);
    }

    public void run() {
        byte[] byArray = new byte[16000];
        while (true) {
            if (this._soundEnabled && this.active) {
                try {
                    int n = this._oscillator.read(byArray);
                    int n2 = this._sourceDataLine.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this._soundEnabled = false;
                    String string = WIStrings.getString("sound.error.io");
                    this.notifySoundErrorListeners(iOException, string);
                }
                continue;
            }
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void notifySoundErrorListeners(IOException iOException, String string) {
        System.out.println("ioe = " + iOException);
        System.out.println("message = " + string);
    }

    public void setFrequency(double d) {
        this._oscillator.setFrequency(d);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }
}

