/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.ScreenChartGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ExpandableScreenChartGraphic
extends PNode {
    private boolean expanded = false;
    private PhetPNode expandNode;
    private ScreenChartGraphic screenChart;
    private PhetPNode closeNode;

    public ExpandableScreenChartGraphic(PSwingCanvas pSwingCanvas, ScreenChartGraphic screenChartGraphic) {
        this.screenChart = screenChartGraphic;
        JButton jButton = new JButton(WIStrings.getString("chart.intensity-graph"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpandableScreenChartGraphic.this.setExpanded(true);
            }
        });
        JButton jButton2 = null;
        try {
            jButton2 = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("wave-interference/images/x-20.png")));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExpandableScreenChartGraphic.this.setExpanded(false);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.closeNode = new PhetPNode(new PSwing(jButton2));
        this.expandNode = new PhetPNode(new PSwing(jButton));
        this.addChild(screenChartGraphic);
        this.addChild(this.expandNode);
        this.addChild(this.closeNode);
        screenChartGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExpandableScreenChartGraphic.this.updateLocation();
            }
        });
        this.update();
        this.updateLocation();
    }

    private void setExpanded(boolean bl) {
        this.expanded = bl;
        this.update();
    }

    private void update() {
        if (this.expanded) {
            this.expandNode.setVisible(false);
            this.screenChart.setVisible(true);
            this.closeNode.setVisible(true);
        } else {
            this.expandNode.setVisible(true);
            this.screenChart.setVisible(false);
            this.closeNode.setVisible(false);
        }
        this.updateLocation();
        this.updateChart();
    }

    private void updateLocation() {
        this.expandNode.setOffset(this.screenChart.getChartBounds().getMinX() + 2.0, this.screenChart.getChartBounds().getCenterY());
        this.closeNode.setOffset(this.screenChart.getChartBounds().getMaxX(), Math.max(this.screenChart.getChartBounds().getY(), 0.0));
    }

    public void updateChart() {
        if (this.screenChart.getVisible()) {
            this.screenChart.updateChart();
        }
    }

    public void reset() {
        this.setExpanded(false);
        this.updateChart();
        this.updateLocation();
    }
}

