/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.tests.BasicWaveTestModule;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import edu.colorado.phet.waveinterference.view.FaucetOnOffControlPanel;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.colorado.phet.waveinterference.view.WaveSideView;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestFaucetModule
extends BasicWaveTestModule {
    private FaucetGraphic faucetGraphic;
    private WaveModelGraphic waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 10, 10, new IndexColorMap(super.getLattice()));
    private WaveSideView waveSideView;

    public TestFaucetModule() {
        super("Faucet");
        super.getPhetPCanvas().addScreenChild(this.waveModelGraphic);
        final ModelSlider modelSlider = new ModelSlider("Cell Dimension", "pixels", 1.0, 50.0, this.waveModelGraphic.getCellDimensions().width);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)modelSlider.getValue();
                TestFaucetModule.this.waveModelGraphic.setCellDimensions(n, n);
            }
        });
        this.getControlPanel().addControl(modelSlider);
        this.waveSideView = new WaveSideView(this.getWaveModel(), this.waveModelGraphic.getLatticeScreenCoordinates());
        this.getPhetPCanvas().addScreenChild(this.waveSideView);
        this.waveModelGraphic.setOffset(300.0, 100.0);
        this.faucetGraphic = new FaucetGraphic(this.getWaveModel(), this.getOscillator(), this.waveModelGraphic.getLatticeScreenCoordinates());
        this.getPhetPCanvas().addScreenChild(this.faucetGraphic);
        this.setOscillatorRadius(2);
        final ModelSlider modelSlider2 = new ModelSlider("Drop Height", "pixels", 0.0, 500.0, this.faucetGraphic.getDropHeight());
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestFaucetModule.this.faucetGraphic.setDropHeight(modelSlider2.getValue());
            }
        });
        final ModelSlider modelSlider3 = new ModelSlider("Drop Speed", "pixels/sec", 0.0, 500.0, this.faucetGraphic.getDropSpeed());
        modelSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestFaucetModule.this.faucetGraphic.setDropSpeed(modelSlider3.getValue());
            }
        });
        this.getControlPanel().addControl(modelSlider2);
        this.getControlPanel().addControl(modelSlider3);
        final JCheckBox jCheckBox = new JCheckBox("Side view", this.waveSideView.getVisible());
        jCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestFaucetModule.this.waveSideView.setVisible(jCheckBox.isSelected());
            }
        });
        this.getControlPanel().addControl(jCheckBox);
        final JCheckBox jCheckBox2 = new JCheckBox("Top View", this.waveModelGraphic.getVisible());
        jCheckBox2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestFaucetModule.this.waveModelGraphic.setVisible(jCheckBox2.isSelected());
            }
        });
        this.getControlPanel().addControl(jCheckBox2);
        FaucetOnOffControlPanel faucetOnOffControlPanel = new FaucetOnOffControlPanel(this.faucetGraphic);
        this.getControlPanel().addControl(faucetOnOffControlPanel);
    }

    protected void step() {
        super.step();
        this.faucetGraphic.step();
        this.waveModelGraphic.update();
        this.waveSideView.update();
    }
}

