/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.tests.BasicWaveTestModule;
import edu.colorado.phet.waveinterference.view.DetectorSetControlPanel;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestStripChartModule
extends BasicWaveTestModule {
    private WaveModelGraphic waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 10, 10, new IndexColorMap(super.getLattice()));
    private IntensityReaderSet intensityReaderSet;

    public TestStripChartModule() {
        super("Strip Chart");
        super.getPhetPCanvas().addScreenChild(this.waveModelGraphic);
        final ModelSlider modelSlider = new ModelSlider("Cell Dimension", "pixels", 1.0, 50.0, this.waveModelGraphic.getCellDimensions().width);
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)modelSlider.getValue();
                TestStripChartModule.this.waveModelGraphic.setCellDimensions(n, n);
            }
        });
        this.intensityReaderSet = new IntensityReaderSet();
        this.getPhetPCanvas().addScreenChild(this.intensityReaderSet);
        DetectorSetControlPanel detectorSetControlPanel = new DetectorSetControlPanel("Amplitude", this.intensityReaderSet, this.getPhetPCanvas(), this.getWaveModel(), this.waveModelGraphic.getLatticeScreenCoordinates(), this.getClock());
        this.getControlPanel().addControl(modelSlider);
        this.getControlPanel().addControl(detectorSetControlPanel);
        detectorSetControlPanel.addIntensityReader("Amplitude");
    }

    protected void step() {
        super.step();
        this.waveModelGraphic.update();
        this.intensityReaderSet.update();
    }
}

