/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;

public class AbstractScreenGraphic
extends PNode {
    private WaveModel waveModel;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private PPath path;
    private float dx = 50.0f;
    private float dy = 30.0f;
    private float cellHeight = 0.0f;

    public AbstractScreenGraphic(WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates) {
        this.waveModel = waveModel;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.path = new PPath();
        this.addChild(this.path);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                AbstractScreenGraphic.this.updateBounds();
            }
        });
        this.updateBounds();
    }

    public float getDx() {
        return this.dx;
    }

    public float getDy() {
        return this.dy;
    }

    public void update() {
    }

    private void updateBounds() {
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() + 1, 0);
        Point2D point2D2 = this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() + 1, this.waveModel.getHeight());
        float f = (float)(point2D2.getY() - point2D.getY());
        this.path.reset();
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo(this.dx, -this.dy);
        this.path.lineTo(this.dx, f - this.dy);
        this.path.lineTo(-this.dx, f + this.dy);
        this.path.lineTo(-this.dx, this.dy);
        this.path.closePath();
        this.path.setStroke(new BasicStroke(3.0f, 1, 1));
        this.path.setPaint(Color.white);
        this.path.setStrokePaint(Color.black);
        this.setOffset(this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth(), 0));
        this.cellHeight = this.computeCellHeight();
    }

    public WaveModel getWaveModel() {
        return this.waveModel;
    }

    public float getYValue(int n) {
        return (float)this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() + 1, n).getY() - this.getOffsetY();
    }

    private float getOffsetY() {
        return (float)this.latticeScreenCoordinates.toScreenCoordinates(0, 0).getY();
    }

    public void setColorMap(ColorMap colorMap) {
    }

    private float computeCellHeight() {
        return (float)(this.latticeScreenCoordinates.toScreenCoordinates(0, 1).getY() - this.latticeScreenCoordinates.toScreenCoordinates(0, 0).getY());
    }

    public float getCellHeight() {
        return this.cellHeight;
    }
}

