/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.AbstractScreenGraphic;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;

public class BrightnessScreenGraphic
extends AbstractScreenGraphic {
    private ArrayList stripes = new ArrayList();
    private ColorMap colorMap;

    public BrightnessScreenGraphic(WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, ColorMap colorMap) {
        super(waveModel, latticeScreenCoordinates);
        this.colorMap = colorMap;
        this.update();
    }

    public void update() {
        this.removeAllStripes();
        for (int i = 0; i < this.getWaveModel().getHeight(); ++i) {
            PPath pPath = new PPath(){

                protected void paint(PPaintContext pPaintContext) {
                    pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                    pPaintContext.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    super.paint(pPaintContext);
                }
            };
            this.fillPathFull(i, pPath);
            this.addBrightnessStripe(pPath);
            Color color = this.getColor(i);
            pPath.setStroke(null);
            pPath.setPaint(color);
        }
    }

    public Color getColor(int n) {
        return this.colorMap.getColor(this.getWaveModel().getWidth() - 1, n);
    }

    private void fillPathFull(int n, PPath pPath) {
        float f = this.getYValue(n);
        pPath.moveTo(0.0f + this.getDx(), f - this.getDy());
        pPath.lineTo(0.0f + this.getDx(), f - this.getDy() + this.getCellHeight() + 1.0f);
        pPath.lineTo(-this.getDx(), f + this.getCellHeight() + 1.0f + this.getDy());
        pPath.lineTo(-this.getDx(), f + this.getDy());
        pPath.closePath();
    }

    private void removeAllStripes() {
        while (this.stripes.size() > 0) {
            this.removeStripe((PPath)this.stripes.get(0));
        }
    }

    private void removeStripe(PPath pPath) {
        this.removeChild(pPath);
        this.stripes.remove(pPath);
    }

    private void addBrightnessStripe(PPath pPath) {
        this.addChild(pPath);
        this.stripes.add(pPath);
    }

    public void setColorMap(ColorMap colorMap) {
        super.setColorMap(colorMap);
        this.colorMap = colorMap;
        this.update();
    }
}

