/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.event.PopupMenuHandler;
import edu.colorado.phet.waveinterference.WallPotential;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.WallPotentialGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CompositeWallPotentialGraphic
extends PNode {
    private JComponent panel;
    private CompositePotential wallPotentialGraphic;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private RotationWaveGraphic rotationWaveGraphic;

    public CompositeWallPotentialGraphic(JComponent jComponent, CompositePotential compositePotential, LatticeScreenCoordinates latticeScreenCoordinates, RotationWaveGraphic rotationWaveGraphic) {
        this.rotationWaveGraphic = rotationWaveGraphic;
        this.panel = jComponent;
        this.wallPotentialGraphic = compositePotential;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        compositePotential.addListener(new CompositePotential.Listener(){

            public void potentialAdded() {
                CompositeWallPotentialGraphic.this.update();
            }

            public void potentialRemoved() {
                CompositeWallPotentialGraphic.this.update();
            }
        });
        this.update();
        rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                CompositeWallPotentialGraphic.this.updateVisible();
            }
        });
        this.updateVisible();
    }

    private void updateVisible() {
        this.setVisible(this.rotationWaveGraphic.getRotation() == 0.0);
    }

    public void reset() {
        this.removeAllChildren();
    }

    private void update() {
        this.removeAllChildren();
        int n = 0;
        while (n < this.wallPotentialGraphic.numPotentials()) {
            WallPotentialGraphic wallPotentialGraphic = new WallPotentialGraphic((WallPotential)this.wallPotentialGraphic.getPotential(n), this.latticeScreenCoordinates);
            final int n2 = n++;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Remove");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CompositeWallPotentialGraphic.this.doDelete(n2);
                }
            });
            jPopupMenu.add(jMenuItem);
            wallPotentialGraphic.addInputEventListener(new PopupMenuHandler(this.panel, jPopupMenu));
            wallPotentialGraphic.addInputEventListener(new PBasicInputEventHandler(){

                public void keyReleased(PInputEvent pInputEvent) {
                    super.keyReleased(pInputEvent);
                    if (pInputEvent.getKeyCode() == 127) {
                        CompositeWallPotentialGraphic.this.doDelete(n2);
                    }
                }
            });
            this.addChild(wallPotentialGraphic);
        }
    }

    private void doDelete(int n) {
        this.wallPotentialGraphic.removePotential(this.wallPotentialGraphic.getPotential(n));
    }
}

