/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class CrossSectionGraphic
extends PhetPNode {
    private WaveModel waveModel;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private PPath path;
    public static final BasicStroke STROKE = new BasicStroke(4.0f, 0, 0, 1.0f, new float[]{15.0f, 10.0f}, 0.0f);
    private int modelY = 30;
    private ArrayList listeners = new ArrayList();

    public CrossSectionGraphic(final WaveModel waveModel, final LatticeScreenCoordinates latticeScreenCoordinates) {
        this.waveModel = waveModel;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.path = new PPath();
        this.path.setStroke(STROKE);
        this.path.setStrokePaint(Color.black);
        this.addChild(this.path);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                CrossSectionGraphic.this.update();
            }
        });
        this.update();
        PDragEventHandler pDragEventHandler = new PDragEventHandler(){
            private Point2D dragStartPt;
            int origLocation;

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                this.dragStartPt = pInputEvent.getCanvasPosition();
                this.origLocation = CrossSectionGraphic.this.modelY;
            }

            protected void drag(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                double d = point2D.getY() - this.dragStartPt.getY();
                double d2 = latticeScreenCoordinates.toLatticeCoordinatesDifferentialY(d);
                CrossSectionGraphic.this.modelY = (int)((double)this.origLocation + d2);
                if (CrossSectionGraphic.this.modelY < 0) {
                    CrossSectionGraphic.this.modelY = 0;
                }
                if (CrossSectionGraphic.this.modelY > waveModel.getHeight() - 1) {
                    CrossSectionGraphic.this.modelY = waveModel.getHeight() - 1;
                }
                CrossSectionGraphic.this.update();
                CrossSectionGraphic.this.notifyListeners();
            }
        };
        this.addInputEventListener(pDragEventHandler);
        this.addInputEventListener(new CursorHandler());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).changed(this.modelY);
        }
    }

    private void update() {
        Rectangle2D rectangle2D = this.latticeScreenCoordinates.getScreenRect();
        double d = this.latticeScreenCoordinates.toScreenCoordinates(0, this.modelY).getY();
        this.path.setPathTo(new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d));
    }

    public void setColor(Color color) {
        this.path.setStrokePaint(color);
    }

    public static interface Listener {
        public void changed(int var1);
    }
}

