/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Point;
import java.awt.geom.Point2D;

public class FaucetDragHandler
extends PDragEventHandler {
    private Oscillator oscillator;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private FaucetGraphic faucetGraphic;
    private Point2D origPosition;
    private Point origOscLoc;

    public FaucetDragHandler(FaucetGraphic faucetGraphic) {
        this.oscillator = faucetGraphic.getOscillator();
        this.latticeScreenCoordinates = faucetGraphic.getLatticeScreenCoordinates();
        this.faucetGraphic = faucetGraphic;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.origPosition = pInputEvent.getPosition();
        this.origOscLoc = new Point(this.oscillator.getCenterX(), this.oscillator.getCenterY());
    }

    protected void drag(PInputEvent pInputEvent) {
        if (this.origPosition == null || this.origOscLoc == null) {
            this.startDrag(pInputEvent);
        }
        Point point = this.getOscillatorDragOffset(pInputEvent);
        this.applyOffset(point);
    }

    protected void applyOffset(Point point) {
        this.oscillator.setLocation(this.origOscLoc.x + point.x, this.origOscLoc.y + point.y);
    }

    private Point getOscillatorDragOffset(PInputEvent pInputEvent) {
        int n = (int)this.latticeScreenCoordinates.toLatticeCoordinatesDifferentialX(pInputEvent.getPosition().getX() - this.origPosition.getX());
        int n2 = (int)this.latticeScreenCoordinates.toLatticeCoordinatesDifferentialY(pInputEvent.getPosition().getY() - this.origPosition.getY());
        return new Point(n, n2);
    }

    protected void endDrag(PInputEvent pInputEvent) {
        this.origPosition = null;
        this.origOscLoc = null;
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }

    public Point getOriginalOscillatorLocation() {
        return this.origOscLoc;
    }
}

