/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.FaucetData;
import edu.colorado.phet.waveinterference.view.FaucetImageData;
import edu.colorado.phet.waveinterference.view.FaucetOnOffControl;
import edu.colorado.phet.waveinterference.view.HorizontalFaucetDragHandler;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.VerticalFaucetDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class FaucetGraphic
extends PhetPNode {
    private PImage image;
    private ArrayList drops = new ArrayList();
    private FaucetData faucetData;
    private PNode waterChild;
    private WaveModel waveModel;
    private Oscillator oscillator;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private double dropHeight = 100.0;
    private double dropSpeed = 100.0;
    private double lastTime;
    private boolean enabled = true;
    private boolean clipDrops = true;
    private ArrayList listeners = new ArrayList();
    private HorizontalFaucetDragHandler horizontalDragHandler;
    private VerticalFaucetDragHandler verticalDragHandler;
    private CursorHandler cursorHandler;

    public FaucetGraphic(WaveModel waveModel, Oscillator oscillator, LatticeScreenCoordinates latticeScreenCoordinates) {
        this(waveModel, oscillator, latticeScreenCoordinates, new FaucetImageData());
    }

    public FaucetGraphic(WaveModel waveModel, Oscillator oscillator, LatticeScreenCoordinates latticeScreenCoordinates, FaucetData faucetData) {
        this.waveModel = waveModel;
        this.oscillator = oscillator;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.faucetData = faucetData;
        this.image = PImageFactory.create(faucetData.getFaucetImageName());
        this.waterChild = new PNode();
        this.addChild(this.waterChild);
        this.addChild(this.image);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                FaucetGraphic.this.updateLocation();
            }
        });
        this.updateLocation();
        oscillator.addListener(new Oscillator.Adapter(){

            public void locationChanged() {
                FaucetGraphic.this.updateLocation();
            }
        });
        FaucetOnOffControl faucetOnOffControl = new FaucetOnOffControl(this);
        faucetOnOffControl.setOffset(0.0, -faucetOnOffControl.getFullBounds().getHeight());
        this.addChild(faucetOnOffControl);
        this.horizontalDragHandler = new HorizontalFaucetDragHandler(this);
        this.verticalDragHandler = new VerticalFaucetDragHandler(this);
        this.cursorHandler = new CursorHandler(CursorHandler.HAND);
    }

    public void setHorizontalDrag() {
        this.removeVerticicalDrag();
        this.addHorizontalDrag();
    }

    public void setVerticalDrag() {
        this.removeHorizontalDrag();
        this.addVerticalDrag();
    }

    private void addVerticalDrag() {
        this.addInputEventListener(this.verticalDragHandler);
        this.addInputEventListener(this.cursorHandler);
    }

    private void removeHorizontalDrag() {
        this.removeInputEventListener(this.horizontalDragHandler);
        this.removeInputEventListener(this.cursorHandler);
    }

    private void addHorizontalDrag() {
        this.addInputEventListener(this.horizontalDragHandler);
        this.addInputEventListener(this.cursorHandler);
    }

    private void removeVerticicalDrag() {
        this.removeInputEventListener(this.verticalDragHandler);
        this.removeInputEventListener(this.cursorHandler);
    }

    public PImage getImagePNode() {
        return this.image;
    }

    private Point2D.Double getDistToOpeningOffset() {
        return new Point2D.Double(this.faucetData.getDistToOpeningX(this.image.getImage()), this.faucetData.getDistToOpeningY(this.image.getImage()));
    }

    private void updateLocation() {
        Point2D.Double double_ = this.getDistToOpeningOffset();
        Point2D point2D = this.getOscillatorScreenCoordinates();
        this.setOffset(point2D.getX() - double_.getX(), point2D.getY() - double_.getY() - this.dropHeight);
    }

    private Point2D getOscillatorScreenCoordinates() {
        return this.latticeScreenCoordinates.toScreenCoordinates(this.oscillator.getCenterX(), this.oscillator.getCenterY());
    }

    public void step() {
        if (this.isEnabled() && this.isRightBeforeReleaseTime(this.lastTime) && this.isRightAfterReleaseTime(this.oscillator.getTime())) {
            this.addDrop();
        }
        this.updateDrops();
        this.lastTime = this.oscillator.getTime();
    }

    private boolean isRightAfterReleaseTime(double d) {
        double d2 = this.getNearestReleaseTime(d);
        return d >= d2 && Math.abs(d2 - d) < this.oscillator.getPeriod() / 4.0;
    }

    private boolean isRightBeforeReleaseTime(double d) {
        double d2 = this.getNearestReleaseTime(d);
        return d < d2 && Math.abs(d2 - d) < this.oscillator.getPeriod() / 4.0;
    }

    private double getNearestReleaseTime(double d) {
        double d2 = d / this.oscillator.getPeriod() - 0.25 + this.getTimeToHitTarget() / this.oscillator.getPeriod();
        int n = (int)Math.round(d2);
        return this.oscillator.getPeriod() / 4.0 - this.getTimeToHitTarget() + (double)n * this.oscillator.getPeriod();
    }

    private void updateDrops() {
        for (int i = 0; i < this.drops.size(); ++i) {
            WaterDropGraphic waterDropGraphic = (WaterDropGraphic)this.drops.get(i);
            waterDropGraphic.update(this.oscillator.getTime() - this.lastTime);
            if (!waterDropGraphic.readyToRemove()) continue;
            this.removeDrop((WaterDropGraphic)this.drops.get(i));
            --i;
            this.oscillator.setEnabled(this.isEnabled());
        }
    }

    private void removeDrop(WaterDropGraphic waterDropGraphic) {
        this.drops.remove(waterDropGraphic);
        this.waterChild.removeChild(waterDropGraphic);
    }

    private void addDrop() {
        WaterDropGraphic waterDropGraphic = new WaterDropGraphic(this.dropSpeed, this.clipDrops, this.oscillator.getAmplitude());
        double d = this.faucetData.getDistToOpeningX(this.image.getImage()) - waterDropGraphic.getFullBounds().getWidth() / 2.0;
        double d2 = this.faucetData.getDistToOpeningY(this.image.getImage()) - waterDropGraphic.getFullBounds().getHeight() / 2.0;
        waterDropGraphic.setOffset(d, d2);
        this.addDrop(waterDropGraphic);
    }

    private double getTimeToHitTarget() {
        return this.dropHeight / this.dropSpeed;
    }

    private void addDrop(WaterDropGraphic waterDropGraphic) {
        this.drops.add(waterDropGraphic);
        this.waterChild.addChild(waterDropGraphic);
    }

    private double getDistanceFromParentOriginToOscillatorY() {
        return -(this.getOffset().getY() - this.getOscillatorScreenCoordinates().getY());
    }

    public double getDropHeight() {
        return this.dropHeight;
    }

    public void setDropHeight(double d) {
        this.dropHeight = d;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!this.enabled && this.drops.size() == 0) {
            this.oscillator.setEnabled(false);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.enabledStateChanged();
        }
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }

    public void setClipDrops(boolean bl) {
        this.clipDrops = bl;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.latticeScreenCoordinates;
    }

    public void reset() {
        while (this.drops.size() > 0) {
            this.removeDrop((WaterDropGraphic)this.drops.get(0));
        }
    }

    public double getDropSpeed() {
        return this.dropSpeed;
    }

    public void setDropSpeed(double d) {
        this.dropSpeed = d;
    }

    public static interface Listener {
        public void enabledStateChanged();
    }

    class WaterDropGraphic
    extends PNode {
        private PImage image;
        private double speed;
        private double amplitude;
        private boolean clip = false;

        public WaterDropGraphic(double d, boolean bl, double d2) {
            this.clip = bl;
            this.speed = d;
            this.amplitude = d2;
            double d3 = d2;
            try {
                BufferedImage bufferedImage = ImageLoader.loadBufferedImage("wave-interference/images/raindrop1.png");
                this.image = new PImage(BufferedImageUtils.rescaleXMaintainAspectRatio(bufferedImage, (int)Math.max(d3 * (double)bufferedImage.getWidth(), 1.0)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.addChild(this.image);
        }

        public void update(double d) {
            this.offset(0.0, this.speed * d);
        }

        public void fullPaint(PPaintContext pPaintContext) {
            Rectangle2D rectangle2D = pPaintContext.getLocalClip();
            Rectangle rectangle = new Rectangle(0, 0, (int)this.getFullBounds().getWidth(), (int)(this.getFullBounds().getHeight() / 2.0 - this.getOffset().getY() + FaucetGraphic.this.getDistanceFromParentOriginToOscillatorY() - this.image.getFullBounds().getHeight() / 2.0));
            this.localToParent(rectangle);
            if (this.clip) {
                pPaintContext.pushClip(rectangle);
            }
            super.fullPaint(pPaintContext);
            if (this.clip) {
                pPaintContext.popClip(rectangle2D);
            }
        }

        public boolean readyToRemove() {
            Rectangle rectangle = new Rectangle(0, 0, (int)this.getFullBounds().getWidth(), (int)(this.getFullBounds().getHeight() / 2.0 - this.getOffset().getY() + FaucetGraphic.this.getDistanceFromParentOriginToOscillatorY() - this.image.getFullBounds().getHeight() / 2.0));
            this.localToParent(rectangle);
            PBounds pBounds = this.getFullBounds();
            return !pBounds.intersects(rectangle);
        }
    }
}

