/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;

public class ImageOscillatorPNode
extends PNode {
    private Oscillator oscillator;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private PImage imageNode;

    public ImageOscillatorPNode(Oscillator oscillator, LatticeScreenCoordinates latticeScreenCoordinates, String string) {
        this.oscillator = oscillator;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.imageNode = PImageFactory.create(string);
        this.addChild(this.imageNode);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                ImageOscillatorPNode.this.updateLocation();
            }
        });
        this.updateLocation();
        oscillator.addListener(new Oscillator.Listener(){

            public void enabledStateChanged() {
            }

            public void locationChanged() {
                ImageOscillatorPNode.this.updateLocation();
            }

            public void frequencyChanged() {
            }

            public void amplitudeChanged() {
            }
        });
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }

    private void updateLocation() {
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(this.oscillator.getCenterX(), this.oscillator.getCenterY());
        this.setOffset(point2D.getX() - this.getFullBounds().getWidth(), point2D.getY() - this.getFullBounds().getHeight() / 2.0);
    }

    public void update() {
    }

    public PImage getImageNode() {
        return this.imageNode;
    }

    public void reset() {
    }
}

