/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.ColorVector;
import java.awt.Color;
import java.util.ArrayList;

public class IntensityColorMap
implements ColorMap {
    private WaveModel waveModel;
    private ColorMap colorMap;
    private ArrayList[][] history = new ArrayList[0][0];
    private int maxHistory = 120;
    private double intensityScale;

    public IntensityColorMap(WaveModel waveModel, ColorMap colorMap) {
        this(waveModel, colorMap, 7.0);
    }

    public IntensityColorMap(WaveModel waveModel, ColorMap colorMap, double d) {
        this.intensityScale = d;
        this.waveModel = waveModel;
        this.colorMap = colorMap;
        waveModel.addListener(new WaveModel.Listener(){

            public void sizeChanged() {
                IntensityColorMap.this.updateSize();
            }
        });
        this.updateSize();
    }

    private void updateSize() {
        this.history = new ArrayList[this.waveModel.getWidth()][this.waveModel.getHeight()];
    }

    public Color getColor(int n, int n2) {
        if (this.history[n][n2] == null) {
            this.update();
        }
        ColorVector colorVector = new ColorVector(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.history[n][n2].size(); ++i) {
            colorVector = colorVector.add(new ColorVector((Color)this.history[n][n2].get(i)));
        }
        colorVector = colorVector.scale((float)(this.intensityScale / (double)this.history[n][n2].size()));
        return colorVector.toColor();
    }

    public Color getRootColor() {
        return this.colorMap.getRootColor();
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void setIntensityScale(double d) {
        this.intensityScale = d;
    }

    public void update() {
        for (int i = 0; i < this.waveModel.getWidth(); ++i) {
            for (int j = 0; j < this.waveModel.getHeight(); ++j) {
                if (this.history[i][j] == null) {
                    this.history[i][j] = new ArrayList();
                }
                Color color = this.colorMap.getColor(i, j);
                this.history[i][j].add(color);
                if (this.history[i][j].size() <= this.maxHistory) continue;
                this.history[i][j].remove(0);
            }
        }
    }
}

