/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.IntensityReader;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class IntensityReaderDecorator
extends PhetPNode {
    private final ArrayList listeners = new ArrayList();
    private final IntensityReader intensityReader;
    private final PSwing buttonPSwing;

    public IntensityReaderDecorator(String string, PSwingCanvas pSwingCanvas, WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, IClock iClock) {
        this.intensityReader = new IntensityReader(string, waveModel, latticeScreenCoordinates, iClock);
        this.intensityReader.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntensityReaderDecorator.this.updateLocation();
            }
        });
        this.intensityReader.getStripChartJFCNode().addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntensityReaderDecorator.this.updateLocation();
            }
        });
        JButton jButton = null;
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("wave-interference/images/x-20.png");
            bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, (int)((double)bufferedImage.getHeight() * 0.6));
            jButton = new JButton(new ImageIcon(bufferedImage));
            jButton.setOpaque(false);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IntensityReaderDecorator.this.delete();
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.buttonPSwing = new PSwing(jButton);
        this.addChild(this.intensityReader);
        this.addChild(this.buttonPSwing);
        this.updateLocation();
    }

    public void delete() {
        this.notifyDeleted();
    }

    private void notifyDeleted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.deleted();
        }
    }

    public void setConstrainedToMidline(boolean bl) {
        this.intensityReader.setConstrainedToMidline(bl);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void updateLocation() {
        PBounds pBounds = this.intensityReader.getStripChartJFCNode().getFullBounds();
        this.intensityReader.localToParent(pBounds);
        this.buttonPSwing.setOffset(((RectangularShape)pBounds).getX() + 2.0, pBounds.getMaxY() - this.buttonPSwing.getFullBounds().getHeight() - 2.0);
    }

    public void update() {
        this.intensityReader.update();
    }

    public static interface Listener {
        public void deleted();
    }
}

