/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.LaserWaveChartControl;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.WaveChartGraphic;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;

public class LaserWaveChartGraphic
extends WaveChartGraphic {
    private VectorView vectorView;
    private PSwingCanvas pSwingCanvas;
    private LaserWaveChartControl laserWaveChartControl;
    private boolean colorized = true;

    public LaserWaveChartGraphic(PSwingCanvas pSwingCanvas, String string, LatticeScreenCoordinates latticeScreenCoordinates, WaveModel waveModel, MutableColor mutableColor, String string2, double d, double d2) {
        super(string, latticeScreenCoordinates, waveModel, mutableColor, string2, d, d2);
        this.pSwingCanvas = pSwingCanvas;
        this.vectorView = new VectorView();
        this.vectorView.setVisible(false);
        this.addChild(this.vectorView);
        this.updateChart();
        this.laserWaveChartControl = new LaserWaveChartControl(pSwingCanvas, this);
        this.addChild(this.laserWaveChartControl);
    }

    public boolean isVectorsVisible() {
        return this.vectorView.getVisible();
    }

    public void setVectorsVisible(boolean bl) {
        this.vectorView.setVisible(bl);
        this.updateChart();
    }

    protected void updateLocation() {
        super.updateLocation();
        if (this.vectorView != null) {
            this.vectorView.setOffset(this.getPathLocation());
        }
        if (this.laserWaveChartControl != null) {
            this.laserWaveChartControl.setOffset(this.getjFreeChartNode().getFullBounds().getMaxX(), this.getjFreeChartNode().getFullBounds().getCenterY() - this.laserWaveChartControl.getFullBounds().getHeight() / 2.0);
        }
    }

    protected double getChartOffset() {
        return 17.0;
    }

    public void updateChart() {
        super.updateChart();
        this.updateVectorView();
    }

    private void updateVectorView() {
        if (this.vectorView != null) {
            this.vectorView.update();
        }
    }

    protected void updateColor() {
        super.updateColor();
        this.updateVectorView();
    }

    public void setColorized(boolean bl) {
        this.colorized = bl;
        super.setColorized(bl);
        this.updateColor();
    }

    public boolean getColorized() {
        return this.colorized;
    }

    public void reset() {
        this.laserWaveChartControl.reset();
    }

    public class VectorView
    extends PhetPNode {
        private boolean indicateOneBlackVector = false;

        public void update() {
            this.removeAllChildren();
            Point2D[] point2DArray = LaserWaveChartGraphic.this.readValues();
            int n = 3;
            for (int i = 0; i < point2DArray.length; i += n) {
                Point2D point2D = point2DArray[i];
                this.addArrow((float)point2D.getX(), (float)point2D.getY());
                if (!this.indicateOneBlackVector || i != point2DArray.length / 4) continue;
                PPath pPath = (PPath)this.getChildrenReference().get(this.getChildrenReference().size() - 1);
                pPath.setPaint(Color.black);
            }
        }

        private void addArrow(float f, float f2) {
            double d = 0.0;
            Arrow arrow = new Arrow(new Point2D.Double(f, d), new Point2D.Double(f, f2), 8.0, 8.0, 4.0, 0.5, true);
            PPath pPath = new PPath(arrow.getShape());
            pPath.setStrokePaint(this.getColor());
            pPath.setStroke(new BasicStroke(2.0f));
            this.addChild(pPath);
        }

        private Color getColor() {
            return LaserWaveChartGraphic.this.colorized ? LaserWaveChartGraphic.this.getStrokeColor().getColor() : Color.black;
        }
    }
}

