/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class LatticeScreenCoordinates {
    private ArrayList listeners = new ArrayList();

    public abstract Point2D toScreenCoordinates(int var1, int var2);

    public abstract Point toLatticeCoordinates(double var1, double var3);

    protected abstract Dimension getGridSize();

    public Rectangle2D getScreenRect() {
        Dimension dimension = this.getGridSize();
        return this.toScreenRect(new Rectangle(0, 0, dimension.width, dimension.height));
    }

    public Rectangle2D toScreenRect(Rectangle rectangle) {
        Point2D point2D = this.toScreenCoordinates(rectangle.x, rectangle.y);
        Point2D point2D2 = this.toScreenCoordinates(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrameFromDiagonal(point2D, point2D2);
        return double_;
    }

    public void notifyMappingChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.mappingChanged();
        }
    }

    public double getCellWidth() {
        return this.toScreenCoordinates(1, 0).getX() - this.toScreenCoordinates(0, 0).getX();
    }

    public double toScreenCoordinatesDifferentialX(int n) {
        return this.toScreenCoordinates(n, 0).getX() - this.toScreenCoordinates(0, 0).getX();
    }

    public double toLatticeCoordinatesDifferentialX(double d) {
        return this.toLatticeCoordinates(d, 0.0).getX() - this.toLatticeCoordinates(0.0, 0.0).getX();
    }

    public double toLatticeCoordinatesDifferentialY(double d) {
        return this.toLatticeCoordinates(0.0, d).getY() - this.toLatticeCoordinates(0.0, 0.0).getY();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void mappingChanged();
    }
}

