/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.waveinterference.phetcommon.IconComponent;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JCheckBox;

public class MeasurementControlPanel
extends VerticalLayoutPanel {
    private MeasurementToolSet measurementToolSet;

    public MeasurementControlPanel(final MeasurementToolSet measurementToolSet) {
        this.measurementToolSet = measurementToolSet;
        final JCheckBox jCheckBox = new JCheckBox(WIStrings.getString("controls.measuring-tape"), measurementToolSet.isMeasuringTapeVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                measurementToolSet.setMeasuringTapeVisible(jCheckBox.isSelected());
            }
        });
        this.add(new IconComponent(jCheckBox, this.getTapeIcon()));
        final JCheckBox jCheckBox2 = new JCheckBox(WIStrings.getString("controls.stopwatch"), measurementToolSet.isStopwatchVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                measurementToolSet.setStopwatchVisible(jCheckBox2.isSelected());
            }
        });
        this.add(new IconComponent(jCheckBox2, this.getClockThumb()));
        measurementToolSet.addListener(new MeasurementToolSet.Listener(){

            public void toolVisibilitiesChanged() {
                jCheckBox.setSelected(measurementToolSet.isMeasuringTapeVisible());
                jCheckBox2.setSelected(measurementToolSet.isStopwatchVisible());
            }
        });
    }

    private BufferedImage getClockThumb() {
        try {
            return ImageLoader.loadBufferedImage("wave-interference/images/stopwatch-thumb.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private BufferedImage getTapeIcon() {
        try {
            return ImageLoader.loadBufferedImage("wave-interference/images/ruler-thumb.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

