/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.MultiFaucetDrip;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiDripControlPanel
extends VerticalLayoutPanel {
    private ModelSlider spacingSlider;
    private JRadioButton twoDrips;
    private JRadioButton oneDrip;
    private MultiFaucetDrip multiFaucetDrip;
    private WaveInterferenceScreenUnits screenUnits;

    public MultiDripControlPanel(final MultiFaucetDrip multiFaucetDrip, WaveInterferenceScreenUnits waveInterferenceScreenUnits) {
        this.multiFaucetDrip = multiFaucetDrip;
        this.screenUnits = waveInterferenceScreenUnits;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.oneDrip = new JRadioButton(WIStrings.getString("controls.one-drip"), multiFaucetDrip.isOneDrip());
        this.oneDrip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                multiFaucetDrip.setOneDrip();
                MultiDripControlPanel.this.updateSpacingSliderEnable();
            }
        });
        this.twoDrips = new JRadioButton(WIStrings.getString("controls.two-drips"), multiFaucetDrip.isTwoDrip());
        this.twoDrips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                multiFaucetDrip.setTwoDrips();
                MultiDripControlPanel.this.updateSpacingSliderEnable();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.oneDrip);
        buttonGroup.add(this.twoDrips);
        this.add(this.oneDrip);
        this.add(this.twoDrips);
        this.spacingSlider = new ModelSlider(WIStrings.getString("controls.spacing"), WIStrings.getString("units.meters"), 0.0, 30.0, multiFaucetDrip.getSpacing());
        this.spacingSlider.setModelLabels(waveInterferenceScreenUnits.toHashtable(new int[]{0, 15, 30}, 2.0));
        this.spacingSlider.setTextFieldVisible(false);
        this.spacingSlider.setBorder(null);
        this.spacingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                multiFaucetDrip.setSpacing(MultiDripControlPanel.this.spacingSlider.getValue());
            }
        });
        this.add(this.spacingSlider);
        this.updateSpacingSliderEnable();
        Oscillator.Adapter adapter = new Oscillator.Adapter(){

            public void locationChanged() {
                MultiDripControlPanel.this.updateSpacingReadout();
            }
        };
        multiFaucetDrip.getPrimary().getOscillator().addListener(adapter);
        multiFaucetDrip.getSecondary().getOscillator().addListener(adapter);
        multiFaucetDrip.addListener(new MultiFaucetDrip.Listener(){

            public void spacingChanged() {
            }

            public void dropCountChanged() {
                MultiDripControlPanel.this.oneDrip.setSelected(multiFaucetDrip.isOneDrip());
                MultiDripControlPanel.this.twoDrips.setSelected(multiFaucetDrip.isTwoDrip());
                MultiDripControlPanel.this.updateSpacingReadout();
                MultiDripControlPanel.this.updateSpacingSliderEnable();
            }
        });
    }

    private void updateSpacingReadout() {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
        while (this.spacingSlider.numChangeListeners() > 0) {
            ChangeListener changeListener = this.spacingSlider.getChangeListener(0);
            this.spacingSlider.removeChangeListener(changeListener);
            arrayList.add(changeListener);
        }
        this.spacingSlider.setValue(this.getDistanceBetweenOscillators() / 2.0);
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            this.spacingSlider.addChangeListener(changeListener);
        }
    }

    private double getDistanceBetweenOscillators() {
        Point2D point2D = this.multiFaucetDrip.getPrimary().getOscillator().getCenter();
        Point2D point2D2 = this.multiFaucetDrip.getSecondary().getOscillator().getCenter();
        return point2D.distance(point2D2);
    }

    private void updateSpacingSliderEnable() {
        this.spacingSlider.setEnabled(this.multiFaucetDrip.isTwoDrip());
    }
}

