/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import java.util.ArrayList;

public class MultiFaucetDrip {
    private boolean twoDrips;
    private double spacing = 10.0;
    private WaveModel waveModel;
    private FaucetGraphic primary;
    private FaucetGraphic secondary;
    private int oscillatorX = 5;
    private ArrayList listeners = new ArrayList();

    public MultiFaucetDrip(WaveModel waveModel, FaucetGraphic faucetGraphic, FaucetGraphic faucetGraphic2) {
        this.waveModel = waveModel;
        this.primary = faucetGraphic;
        this.secondary = faucetGraphic2;
        faucetGraphic.getOscillator().addListener(new Oscillator.Adapter(){

            public void frequencyChanged() {
                MultiFaucetDrip.this.updateSecondary();
            }

            public void amplitudeChanged() {
                MultiFaucetDrip.this.updateSecondary();
            }
        });
        this.setOneDrip();
        this.updateSecondary();
    }

    public void reset() {
        this.setOneDrip();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifySpacingChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.spacingChanged();
        }
    }

    private void updateSecondary() {
        this.secondary.getOscillator().setAmplitude(this.primary.getOscillator().getAmplitude());
        this.secondary.getOscillator().setFrequency(this.primary.getOscillator().getFrequency());
    }

    public boolean isOneDrip() {
        return !this.isTwoDrip();
    }

    public boolean isTwoDrip() {
        return this.twoDrips;
    }

    public void setOneDrip() {
        this.twoDrips = false;
        this.update();
        this.notifyDropCountChanged();
    }

    private void notifyDropCountChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.dropCountChanged();
        }
    }

    private void update() {
        this.secondary.setEnabled(this.twoDrips);
        this.secondary.setVisible(this.twoDrips);
        if (this.twoDrips) {
            this.primary.getOscillator().setLocation(this.oscillatorX, (int)((double)(this.waveModel.getHeight() / 2) - this.spacing));
            this.secondary.getOscillator().setLocation(this.oscillatorX, (int)((double)(this.waveModel.getHeight() / 2) + this.spacing));
        } else {
            this.primary.getOscillator().setLocation(this.oscillatorX, this.waveModel.getHeight() / 2);
        }
        if (this.twoDrips) {
            this.primary.setVerticalDrag();
            this.secondary.setVerticalDrag();
        } else {
            this.primary.setHorizontalDrag();
        }
    }

    public void setTwoDrips() {
        this.twoDrips = true;
        this.update();
        this.notifyDropCountChanged();
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d) {
        this.spacing = d;
        this.update();
        this.notifySpacingChanged();
    }

    public FaucetGraphic getPrimary() {
        return this.primary;
    }

    public FaucetGraphic getSecondary() {
        return this.secondary;
    }

    public static interface Listener {
        public void spacingChanged();

        public void dropCountChanged();
    }
}

