/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class MultiOscillator {
    boolean twoSources;
    private double spacing = 10.0;
    private WaveModel waveModel;
    private PNode primary;
    private Oscillator primaryOscillator;
    private PNode secondary;
    private Oscillator secondaryOscillator;
    private int oscillatorX = 5;
    private ArrayList listeners = new ArrayList();

    public MultiOscillator(WaveModel waveModel, PNode pNode, final Oscillator oscillator, PNode pNode2, final Oscillator oscillator2) {
        this.waveModel = waveModel;
        this.primary = pNode;
        this.primaryOscillator = oscillator;
        this.secondary = pNode2;
        this.secondaryOscillator = oscillator2;
        oscillator.addListener(new Oscillator.Adapter(){

            public void frequencyChanged() {
                oscillator2.setFrequency(oscillator.getFrequency());
            }

            public void amplitudeChanged() {
                oscillator2.setAmplitude(oscillator.getAmplitude());
            }
        });
        oscillator2.setFrequency(oscillator.getFrequency());
        oscillator2.setAmplitude(oscillator.getAmplitude());
        this.setOneDrip();
    }

    public boolean isOneSource() {
        return !this.isTwoSource();
    }

    public boolean isTwoSource() {
        return this.twoSources;
    }

    public void setOneDrip() {
        this.twoSources = false;
        this.update();
    }

    private void update() {
        this.secondaryOscillator.setEnabled(this.twoSources);
        this.secondary.setVisible(this.twoSources);
        if (this.twoSources) {
            this.primaryOscillator.setLocation(this.oscillatorX, (int)((double)(this.waveModel.getHeight() / 2) - this.spacing));
            this.secondaryOscillator.setLocation(this.oscillatorX, (int)((double)(this.waveModel.getHeight() / 2) + this.spacing));
        } else {
            this.primaryOscillator.setLocation(this.oscillatorX, this.waveModel.getHeight() / 2);
        }
        this.notifyListeners();
    }

    public void setTwoDrips() {
        this.twoSources = true;
        this.update();
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d) {
        this.spacing = d;
        this.update();
    }

    public void reset() {
        this.setOneDrip();
        this.setSpacing(10.0);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.multiOscillatorChanged();
        }
    }

    public static interface Listener {
        public void multiOscillatorChanged();
    }
}

