/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.PulseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class OscillatorOnOffControlPanel
extends VerticalLayoutPanel {
    private Oscillator oscillator;
    private JRadioButton onRadioButton;
    private JRadioButton offRadioButton;
    private PulseButton pulseButton;

    public OscillatorOnOffControlPanel(final Oscillator oscillator) {
        this.oscillator = oscillator;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.onRadioButton = new JRadioButton(WIStrings.getString("controls.on"), oscillator.isEnabled());
        this.onRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                oscillator.setEnabled(OscillatorOnOffControlPanel.this.onRadioButton.isSelected());
                OscillatorOnOffControlPanel.this.updatePulseEnabled();
            }
        });
        buttonGroup.add(this.onRadioButton);
        this.add(this.onRadioButton);
        this.offRadioButton = new JRadioButton(WIStrings.getString("controls.off"), !oscillator.isEnabled());
        this.offRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                oscillator.setEnabled(!OscillatorOnOffControlPanel.this.offRadioButton.isSelected());
                OscillatorOnOffControlPanel.this.updatePulseEnabled();
            }
        });
        oscillator.addListener(new Oscillator.Adapter(){

            public void enabledStateChanged() {
                OscillatorOnOffControlPanel.this.updateState();
            }
        });
        buttonGroup.add(this.offRadioButton);
        this.add(this.offRadioButton);
        this.pulseButton = new PulseButton(oscillator);
        this.add(this.pulseButton);
        this.updatePulseEnabled();
    }

    private void updatePulseEnabled() {
    }

    private void updateState() {
        this.onRadioButton.setSelected(this.oscillator.isEnabled());
        this.offRadioButton.setSelected(!this.oscillator.isEnabled());
    }
}

