/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.BasicColorMap;
import edu.colorado.phet.waveinterference.view.ColorMap;
import java.awt.Color;

public class PhotonEmissionColorMap
implements Resettable,
ColorMap {
    private WaveModel lattice;
    private boolean[][] inited;
    private Color color;
    private BasicColorMap basicColorMap;

    public PhotonEmissionColorMap(final WaveModel waveModel, Color color) {
        this.color = color;
        this.lattice = waveModel;
        this.inited = new boolean[waveModel.getWidth()][waveModel.getHeight()];
        waveModel.addListener(0, new WaveModel.Listener(){

            public void sizeChanged() {
                System.out.println("PhotonEmissionColorMap.sizeChanged");
                PhotonEmissionColorMap.access$002(PhotonEmissionColorMap.this, new boolean[waveModel.getWidth()][waveModel.getHeight()]);
                PhotonEmissionColorMap.this.debug();
            }
        });
        this.basicColorMap = new BasicColorMap(waveModel.getLattice(), color);
    }

    private void debug() {
        System.out.println("lattice.getWidth() = " + this.lattice.getWidth() + ", h=" + this.lattice.getHeight());
        System.out.println("inited.length = " + this.inited.length + ", inited[0].length=" + this.inited[0].length);
    }

    public Color getColor(int n, int n2) {
        float f = this.lattice.getLattice().getValue(n, n2);
        float f2 = 0.025f;
        if (Math.abs(f) < f2 && !this.inited[n][n2]) {
            return Color.black;
        }
        this.inited[n][n2] = true;
        return this.basicColorMap.getColor(n, n2);
    }

    public Color getRootColor() {
        return this.color;
    }

    public int getWidth() {
        return this.inited.length;
    }

    public int getHeight() {
        return this.inited[0].length;
    }

    public void setDark(int n, int n2) {
        this.inited[n][n2] = false;
    }

    public void reset() {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                this.setDark(i, j);
            }
        }
    }

    static /* synthetic */ boolean[][] access$002(PhotonEmissionColorMap photonEmissionColorMap, boolean[][] blArray) {
        photonEmissionColorMap.inited = blArray;
        return blArray;
    }
}

