/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SRRWavelengthSlider
extends PNode {
    private SpectrumSliderKnob spectrumSliderKnob;
    private Function.LinearFunction linearFunction;
    private PImage colorBackgroundNode;
    private PText phetTextGraphic;
    private PPath boundGraphic;
    private ArrayList listeners = new ArrayList();

    public SRRWavelengthSlider() {
        this(175, 30);
    }

    public SRRWavelengthSlider(int n, int n2) {
        double d = 380.0;
        double d2 = 780.0;
        final BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.linearFunction = new Function.LinearFunction(0.0, bufferedImage.getWidth(), d, d2);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            double d3 = this.linearFunction.evaluate(i);
            VisibleColor visibleColor = new VisibleColor(d3);
            graphics2D.setColor(visibleColor);
            graphics2D.fillRect(i, 0, 1, bufferedImage.getHeight());
        }
        graphics2D.dispose();
        this.colorBackgroundNode = new PImage(bufferedImage);
        this.spectrumSliderKnob = new SpectrumSliderKnob(new Dimension(20, 20), 0.0);
        this.spectrumSliderKnob.setOffset(0.0, bufferedImage.getHeight());
        this.spectrumSliderKnob.addInputEventListener(new CursorHandler(12));
        this.spectrumSliderKnob.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseEntered(PInputEvent pInputEvent) {
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                super.mouseDragged(pInputEvent);
                Point2D point2D = pInputEvent.getPositionRelativeTo(SRRWavelengthSlider.this);
                double d = (int)MathUtil.clamp(0.0, point2D.getX(), bufferedImage.getWidth());
                SRRWavelengthSlider.this.spectrumSliderKnob.setOffset(new Point2D.Double(d, (double)bufferedImage.getHeight() + SRRWavelengthSlider.this.getTextOffsetY()));
                SRRWavelengthSlider.this.dragPointChanged();
            }
        });
        this.phetTextGraphic = new PText("");
        this.colorBackgroundNode.setOffset(0.0, this.getTextOffsetY());
        double d4 = 0.7;
        this.spectrumSliderKnob.setOffset((double)bufferedImage.getWidth() * d4, (double)bufferedImage.getHeight() + this.getTextOffsetY());
        this.addChild(this.phetTextGraphic);
        this.addChild(this.colorBackgroundNode);
        this.addChild(this.spectrumSliderKnob);
        this.layoutChildren();
        this.boundGraphic = new PPath(this.getFullBounds());
        this.boundGraphic.setPaint(new JLabel().getBackground());
        this.boundGraphic.setStrokePaint(null);
        this.boundGraphic.setPickable(false);
        this.boundGraphic.setChildrenPickable(false);
        this.addChild(0, this.boundGraphic);
        this.dragPointChanged();
        this.setOpaque(false);
    }

    private double getTextOffsetY() {
        return this.phetTextGraphic.getHeight() + 5.0;
    }

    public VisibleColor getVisibleColor() {
        return new VisibleColor(this.getWavelength());
    }

    private void dragPointChanged() {
        double d = this.getWavelength();
        this.spectrumSliderKnob.setPaint(new VisibleColor(d));
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public void setSelectedWavelength(double d) {
        double d2 = this.linearFunction.createInverse().evaluate(d);
        if (!MathUtil.isApproxEqual(d2, this.spectrumSliderKnob.getOffset().getX(), 0.001)) {
            this.spectrumSliderKnob.setOffset(d2, this.spectrumSliderKnob.getOffset().getY());
            this.spectrumSliderKnob.setPaint(new VisibleColor(d));
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
                changeListener.stateChanged(changeEvent);
            }
            this.repaint();
        }
    }

    public double getWavelength() {
        double d = this.spectrumSliderKnob.getOffset().getX();
        return this.linearFunction.evaluate(d);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void setOpaque(boolean bl) {
        this.boundGraphic.setVisible(bl);
    }

    public class SpectrumSliderKnob
    extends PPath {
        private Dimension _size;
        private double _angle;

        public SpectrumSliderKnob(Dimension dimension, double d) {
            this._size = new Dimension(dimension);
            this._angle = d;
            super.setPaint(Color.WHITE);
            super.setStroke(new BasicStroke(1.0f));
            super.setStrokePaint(Color.BLACK);
            this.updateShape();
        }

        private void updateShape() {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(-0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
            generalPath.lineTo(-0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
            generalPath.lineTo(0.5f * (float)this._size.width, 1.0f * (float)this._size.height);
            generalPath.lineTo(0.5f * (float)this._size.width, 0.3f * (float)this._size.height);
            generalPath.closePath();
            super.setPathTo(generalPath);
        }
    }
}

