/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.ScreenNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

public class ScreenControlPanel
extends VerticalLayoutPanel {
    private ScreenNode screenNode;

    public ScreenControlPanel(final ScreenNode screenNode) {
        this.screenNode = screenNode;
        this.setBorder(BorderFactory.createTitledBorder(WIStrings.getString("light.screen")));
        final JCheckBox jCheckBox = new JCheckBox(WIStrings.getString("light.show-screen"), screenNode.isScreenEnabled());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenNode.setScreenEnabled(jCheckBox.isSelected());
            }
        });
        this.add(jCheckBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(WIStrings.getString("light.curve"), screenNode.isCurveMode());
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenNode.setCurveMode();
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton(WIStrings.getString("readout.intensity"), screenNode.isIntensityMode());
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                screenNode.setIntensityMode();
            }
        });
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        this.add(jRadioButton2);
        this.add(jRadioButton);
    }
}

