/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.BrightnessScreenGraphic;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.CurveScreenGraphic;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.IntensityColorMap;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.colorado.phet.waveinterference.view.WaveValueReader;
import java.util.ArrayList;

public class ScreenNode
extends PhetPNode {
    private boolean enabled = false;
    private boolean intensityMode = true;
    private CurveScreenGraphic curveScreenGraphic;
    private BrightnessScreenGraphic brightnessScreenGraphic;
    private WaveModel waveModel;
    private IntensityColorMap intensityColorMap;
    private ArrayList listeners = new ArrayList();

    public ScreenNode(WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, final WaveModelGraphic waveModelGraphic) {
        this.waveModel = waveModel;
        this.curveScreenGraphic = new CurveScreenGraphic(waveModel, latticeScreenCoordinates);
        this.intensityColorMap = new IntensityColorMap(waveModel, waveModelGraphic.getColorMap());
        this.brightnessScreenGraphic = new BrightnessScreenGraphic(waveModel, latticeScreenCoordinates, this.intensityColorMap);
        this.addChild(this.curveScreenGraphic);
        this.addChild(this.brightnessScreenGraphic);
        waveModelGraphic.addListener(new WaveModelGraphic.Listener(){

            public void colorMapChanged() {
                ScreenNode.this.setColorMap(waveModelGraphic.getColorMap());
            }
        });
        this.update();
    }

    public boolean isScreenEnabled() {
        return this.enabled;
    }

    public boolean isCurveMode() {
        return !this.isIntensityMode();
    }

    public boolean isIntensityMode() {
        return this.intensityMode;
    }

    public void setScreenEnabled(boolean bl) {
        this.enabled = bl;
        this.update();
        this.notifyEnabledStateChanged();
    }

    public void update() {
        this.curveScreenGraphic.setVisible(this.isCurveMode() && this.isScreenEnabled());
        this.brightnessScreenGraphic.setVisible(this.isIntensityMode() && this.isScreenEnabled());
        this.updateScreen();
    }

    public void setIntensityMode() {
        this.intensityMode = true;
        this.update();
    }

    public void setCurveMode() {
        this.intensityMode = false;
        this.update();
    }

    public void setColorMap(ColorMap colorMap) {
        this.curveScreenGraphic.setColorMap(colorMap);
        this.intensityColorMap.setColorMap(new IndexColorMap(this.waveModel.getLattice(), colorMap.getRootColor(), (WaveValueReader)new WaveValueReader.AverageAbs(2)));
    }

    public void updateScreen() {
        this.intensityColorMap.update();
        if (this.curveScreenGraphic.getVisible()) {
            this.curveScreenGraphic.update();
        } else if (this.brightnessScreenGraphic.getVisible()) {
            this.brightnessScreenGraphic.update();
        }
    }

    public void setIntensityScale(double d) {
        this.intensityColorMap.setIntensityScale(d);
    }

    public BrightnessScreenGraphic getBrightnessScreenGraphic() {
        return this.brightnessScreenGraphic;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.setScreenEnabled(false);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyEnabledStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.enabledStateChanged();
        }
    }

    public static interface Listener {
        public void enabledStateChanged();
    }
}

