/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StripChartJFCNode
extends PNode {
    private XYSeries series;
    private JFreeChart jFreeChart;
    private JFreeChartNode jFreeChartNode;
    private boolean enabled = true;

    public StripChartJFCNode(int n, int n2, String string, String string2) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        this.series = new XYSeries((Comparable)((Object)WIStrings.getString("controls.time-series")));
        xYSeriesCollection.addSeries(this.series);
        this.jFreeChart = StripChartJFCNode.createChart(xYSeriesCollection, string, string2);
        this.jFreeChart.setBorderVisible(true);
        this.jFreeChart.setBorderStroke(new BasicStroke(5.0f));
        this.jFreeChartNode = new JFreeChartNode(this.jFreeChart);
        this.addChild(this.jFreeChartNode);
        this.jFreeChartNode.setBounds(0.0, 0.0, n, n2);
        this.jFreeChart.setBorderPaint(new GradientPaint(0.0f, 0.0f, new Color(200, 200, 200, 255), (float)this.jFreeChartNode.getFullBounds().getWidth(), (float)this.jFreeChartNode.getFullBounds().getHeight(), Color.darkGray));
        try {
            this.jFreeChart.setBackgroundImage(ImageLoader.loadBufferedImage("wave-interference/images/wood.jpg"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static JFreeChart createChart(XYDataset xYDataset, String string, String string2) {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("", string, string2, xYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.getRangeAxis().setTickLabelsVisible(false);
        xYPlot.getRangeAxis().setAutoRange(false);
        xYPlot.getRangeAxis().setRange(-1.0, 1.0);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        xYLineAndShapeRenderer.setStroke(new BasicStroke(2.0f, 0, 0, 1.0f));
        xYLineAndShapeRenderer.setPaint(Color.blue);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        return jFreeChart;
    }

    public void addValue(double d, double d2) {
        if (this.enabled) {
            this.series.add(d, d2, this.series.getItemCount() < 100);
            if (this.series.getItemCount() < 10) {
                double d3 = this.series.getX(0).doubleValue();
                double d4 = d - d3;
                double d5 = d4 * 100.0 / (double)(this.series.getItemCount() - 1) + d3;
                this.jFreeChart.getXYPlot().getDomainAxis().setRange(d3, d5);
            } else if (this.series.getItemCount() == 100) {
                this.jFreeChart.getXYPlot().getDomainAxis().setAutoRange(true);
            }
            if (this.series.getItemCount() > 100) {
                this.series.remove(0);
            }
        }
    }
}

