/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.waveinterference.WallPotential;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class WallPotentialGraphic
extends PNode {
    private WallPotential wallPotential;
    private LatticeScreenCoordinates latticeScreenCoordinates;

    public WallPotentialGraphic(WallPotential wallPotential, LatticeScreenCoordinates latticeScreenCoordinates) {
        this.wallPotential = wallPotential;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                WallPotentialGraphic.this.update();
            }
        });
        wallPotential.addListener(new WallPotential.Listener(){

            public void changed() {
                WallPotentialGraphic.this.update();
            }
        });
        this.update();
        this.addInputEventListener(new CursorHandler());
    }

    private void update() {
        this.removeAllChildren();
        Line2D.Double double_ = new Line2D.Double(this.latticeScreenCoordinates.toScreenCoordinates(this.wallPotential.getSource().x, this.wallPotential.getSource().y), this.latticeScreenCoordinates.toScreenCoordinates(this.wallPotential.getDestination().x, this.wallPotential.getDestination().y));
        float f = (float)this.latticeScreenCoordinates.toScreenCoordinatesDifferentialX(this.wallPotential.getThickness());
        Shape shape = new BasicStroke(f).createStrokedShape(double_);
        PhetPPath phetPPath = new PhetPPath(shape, SlitPotentialGraphic.BARRIER_FILL, SlitPotentialGraphic.BARRIER_STROKE, SlitPotentialGraphic.BARRIER_STROKE_PAINT);
        this.addChild(phetPPath);
        MyPDragEventHandler myPDragEventHandler = new MyPDragEventHandler(true, true);
        phetPPath.addInputEventListener(myPDragEventHandler);
        Color color = new Color(177, 120, 40);
        Ellipse2D.Double double_2 = new Ellipse2D.Double();
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(this.wallPotential.getSource().x, this.wallPotential.getSource().y);
        double_2.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D.getX() + (double)f * 0.8 / 2.0, point2D.getY() + (double)f * 0.8 / 2.0);
        PhetPPath phetPPath2 = new PhetPPath(double_2, color, new BasicStroke(), Color.black);
        this.addChild(phetPPath2);
        phetPPath2.addInputEventListener(new MyPDragEventHandler(true, false));
        double_2 = new Ellipse2D.Double();
        point2D = this.latticeScreenCoordinates.toScreenCoordinates(this.wallPotential.getDestination().x, this.wallPotential.getDestination().y);
        double_2.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D.getX() + (double)f * 0.8 / 2.0, point2D.getY() + (double)f * 0.8 / 2.0);
        phetPPath2 = new PhetPPath(double_2, color, new BasicStroke(), Color.black);
        this.addChild(phetPPath2);
        phetPPath2.addInputEventListener(new MyPDragEventHandler(false, true));
    }

    private class MyPDragEventHandler
    extends PDragEventHandler {
        private Point2D dragStartPt;
        private Point origStart;
        private Point origEnd;
        private boolean changeStart;
        private boolean changeEnd;

        private MyPDragEventHandler(boolean bl, boolean bl2) {
            this.changeStart = bl;
            this.changeEnd = bl2;
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            this.dragStartPt = pInputEvent.getCanvasPosition();
            this.origStart = WallPotentialGraphic.this.wallPotential.getSource();
            this.origEnd = WallPotentialGraphic.this.wallPotential.getDestination();
        }

        protected void drag(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getCanvasPosition();
            double d = WallPotentialGraphic.this.latticeScreenCoordinates.toLatticeCoordinatesDifferentialX(point2D.getX() - this.dragStartPt.getX());
            double d2 = WallPotentialGraphic.this.latticeScreenCoordinates.toLatticeCoordinatesDifferentialY(point2D.getY() - this.dragStartPt.getY());
            if (this.changeStart) {
                WallPotentialGraphic.this.wallPotential.setSrcPoint(new Point(this.origStart.x + (int)d, this.origStart.y + (int)d2));
            }
            if (this.changeEnd) {
                WallPotentialGraphic.this.wallPotential.setDstPoint(new Point(this.origEnd.x + (int)d, this.origEnd.y + (int)d2));
            }
        }
    }
}

