/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.WaveSampler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.MessageFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class WaveChartGraphic
extends PNode {
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private WaveModel waveModel;
    private MutableColor strokeColor;
    private JFreeChart jFreeChart;
    private JFreeChartNode jFreeChartNode;
    private PPath path;
    private boolean colorized = true;
    private int crossSectionY;

    public WaveChartGraphic(String string, LatticeScreenCoordinates latticeScreenCoordinates, WaveModel waveModel, MutableColor mutableColor, String string2, double d, double d2) {
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.waveModel = waveModel;
        this.strokeColor = mutableColor;
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"0"));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        this.jFreeChart = ChartFactory.createXYLineChart(string, WIStrings.getString("readout.position"), string, xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        this.jFreeChart.getXYPlot().getRangeAxis().setTickLabelsVisible(false);
        this.jFreeChart.getXYPlot().getRangeAxis().setRange(-1.0, 1.0);
        this.jFreeChartNode = new JFreeChartNode(this.jFreeChart, true);
        this.jFreeChartNode.setBounds(0.0, 0.0, 500.0, 185.0);
        this.setHorizontalLabel(MessageFormat.format(WIStrings.getString("controls.position"), string2));
        this.setHorizontalRange(d, d2);
        this.crossSectionY = latticeScreenCoordinates.getGridSize().height / 2;
        this.jFreeChartNode.updateChartRenderingInfo();
        this.path = new PPath();
        this.path.setStroke(new BasicStroke(3.0f));
        this.path.setStrokePaint(Color.blue);
        this.addChild(this.jFreeChartNode);
        this.addChild(this.path);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                WaveChartGraphic.this.updateLocation();
            }
        });
        this.updateLocation();
        mutableColor.addListener(new MutableColor.Listener(){

            public void colorChanged() {
                WaveChartGraphic.this.updateColor();
            }
        });
        this.updateColor();
    }

    public void setHorizontalLabel(String string) {
        this.jFreeChart.getXYPlot().getDomainAxis().setLabel(string);
    }

    public void setHorizontalRange(double d, double d2) {
        this.jFreeChart.getXYPlot().getDomainAxis().setRange(d, d2);
    }

    public Rectangle2D getChartBounds() {
        PBounds pBounds = this.jFreeChartNode.getFullBounds();
        this.localToParent(pBounds);
        return pBounds;
    }

    protected void updateLocation() {
        this.synchronizeWidth();
        this.synchronizeWidth();
        PBounds pBounds = this.jFreeChartNode.getBounds();
        Rectangle2D rectangle2D = this.jFreeChartNode.getDataArea();
        double d = this.latticeScreenCoordinates.toScreenCoordinates(0, 0).getX();
        double d2 = this.latticeScreenCoordinates.toScreenCoordinates(0, this.waveModel.getHeight()).getY() + this.getChartOffset();
        double d3 = rectangle2D.getX() - ((RectangularShape)pBounds).getX();
        this.jFreeChartNode.setBounds(0.0, 0.0, ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight());
        this.jFreeChartNode.setOffset(d - d3, d2);
    }

    protected double getChartOffset() {
        return 0.0;
    }

    private void synchronizeWidth() {
        double d = this.getDesiredDataWidth() - this.getActualDataWidth();
        this.changeDataWidth((int)d);
    }

    private void changeDataWidth(int n) {
        PBounds pBounds = this.jFreeChartNode.getBounds();
        this.jFreeChartNode.setBounds(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY(), ((RectangularShape)pBounds).getWidth() + (double)n, ((RectangularShape)pBounds).getHeight());
        this.jFreeChartNode.updateChartRenderingInfo();
    }

    private double getActualDataWidth() {
        return this.jFreeChartNode.getDataArea().getWidth();
    }

    public JFreeChartNode getjFreeChartNode() {
        return this.jFreeChartNode;
    }

    private double getDesiredDataWidth() {
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(0, 0);
        Point2D point2D2 = this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() - 1, this.waveModel.getHeight() - 1);
        return point2D2.getX() - point2D.getX();
    }

    public void updateChart() {
        GeneralPath generalPath = new GeneralPath();
        Point2D[] point2DArray = this.readValues();
        if (point2DArray.length > 0) {
            generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
        }
        for (int i = 1; i < point2DArray.length; ++i) {
            generalPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
        }
        this.path.setPathTo(generalPath);
        this.path.setOffset(this.getPathLocation());
    }

    protected Point2D getPathLocation() {
        Point2D point2D = this.jFreeChartNode.plotToNode(new Point2D.Double(0.0, 0.0));
        this.jFreeChartNode.localToParent(point2D);
        return point2D;
    }

    protected Point2D[] readValues() {
        return new WaveSampler(this.waveModel, -60.0, this.latticeScreenCoordinates.getCellWidth()).readValues(this.crossSectionY);
    }

    public void setCurveColor(Color color) {
        this.strokeColor.setColor(color);
        this.updateColor();
    }

    protected void updateColor() {
        this.path.setStrokePaint(this.colorized ? this.strokeColor.getColor() : Color.black);
    }

    public double getChartHeight() {
        return this.jFreeChartNode.getFullBounds().getHeight();
    }

    public MutableColor getStrokeColor() {
        return this.strokeColor;
    }

    public void setCurveVisible(boolean bl) {
        this.path.setVisible(bl);
    }

    public boolean isCurveVisible() {
        return this.path.getVisible();
    }

    public void setColorized(boolean bl) {
        this.colorized = bl;
        this.updateColor();
    }

    public void setCrossSectionYValue(int n) {
        this.crossSectionY = n;
        this.updateChart();
    }
}

