/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class WaveSampler {
    private WaveModel waveModel;
    private double distBetweenPoints;
    private double amplitudeScale;

    public WaveSampler(WaveModel waveModel, double d, double d2) {
        this.waveModel = waveModel;
        this.amplitudeScale = d;
        this.distBetweenPoints = d2;
    }

    public Point2D[] readValues(int n) {
        Lattice2D lattice2D = this.getLattice();
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        for (int i = 0; i < lattice2D.getWidth(); ++i) {
            float f = this.getY(i, n);
            float f2 = this.getX(i);
            arrayList.add(new Point2D.Float(f2, f));
        }
        return arrayList.toArray(new Point2D.Float[0]);
    }

    private Lattice2D getLattice() {
        return this.waveModel.getLattice();
    }

    protected float getX(int n) {
        return (float)((double)n * this.distBetweenPoints);
    }

    protected float getY(int n, int n2) {
        if (n >= 1 && n < this.getLattice().getWidth() - 1) {
            double d = this.getVerticalSlice(n, n2) + this.getVerticalSlice(n - 1, n2) + this.getVerticalSlice(n + 1, n2);
            return (float)(d / 3.0);
        }
        return (float)this.getVerticalSlice(n, n2);
    }

    private double getVerticalSlice(int n, int n2) {
        if (n2 >= 1 && n2 < this.getLattice().getHeight() - 1) {
            double d = this.getYORIG(n, n2 + 1) + this.getYORIG(n, n2 - 1) + this.getYORIG(n, n2);
            return d / 3.0;
        }
        return this.getYORIG(n, n2);
    }

    private float getYORIG(int n, int n2) {
        return (float)((double)this.getLattice().getValue(n, n2) * this.amplitudeScale);
    }

    public void setDistanceBetweenCells(double d) {
        this.distBetweenPoints = d;
    }
}

