/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Lattice2D;

public interface WaveValueReader {
    public double getValue(Lattice2D var1, int var2, int var3);

    public static class AverageAbs
    implements WaveValueReader {
        int numNeighbors;

        public AverageAbs() {
            this(1);
        }

        public AverageAbs(int n) {
            this.numNeighbors = n;
        }

        public double getValue(Lattice2D lattice2D, int n, int n2) {
            double d = Math.abs(lattice2D.getAverageValue(n, n2, this.numNeighbors));
            if (d > 1.0) {
                d = 1.0;
            }
            return d;
        }
    }

    public static class Displacement
    implements WaveValueReader {
        public double getValue(Lattice2D lattice2D, int n, int n2) {
            float f = (lattice2D.getValue(n, n2) + 1.0f) / 2.0f;
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            return f;
        }
    }
}

