/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.PhotonEmissionColorMap;
import edu.colorado.phet.waveinterference.view.SRRWavelengthSliderComponent;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WavelengthControlPanel
extends VerticalLayoutPanel {
    private SRRWavelengthSliderComponent slider;
    private WaveModelGraphic waveModelGraphic;
    private Oscillator oscillator;
    private double speedOfLight = 1000.0;

    public WavelengthControlPanel(WaveModelGraphic waveModelGraphic, final Oscillator oscillator) {
        this.addFullWidth(new JLabel(WIStrings.getString("controls.wavelength")));
        this.waveModelGraphic = waveModelGraphic;
        this.oscillator = oscillator;
        this.slider = new SRRWavelengthSliderComponent();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WavelengthControlPanel.this.update();
            }
        });
        oscillator.addListener(new Oscillator.Adapter(){

            public void frequencyChanged() {
                WavelengthControlPanel.this.slider.updateSelectedWavelength(WavelengthControlPanel.this.speedOfLight / oscillator.getFrequency());
            }
        });
        this.add(this.slider);
        this.update();
    }

    protected void update() {
        this.getWaveModel().clear();
        this.waveModelGraphic.setColorMap(new PhotonEmissionColorMap(this.getWaveModel(), this.getColor()));
        double d = this.speedOfLight / this.slider.getWavelength();
        this.oscillator.setFrequency(d);
    }

    private WaveModel getWaveModel() {
        return this.waveModelGraphic.getWaveModel();
    }

    public Color getColor() {
        return this.slider.getColor();
    }
}

